% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_statistic.R
\name{get_statistic}
\alias{get_statistic}
\alias{get_statistic.default}
\alias{get_statistic.glmmTMB}
\alias{get_statistic.emmGrid}
\alias{get_statistic.gee}
\title{Get statistic associated with estimates}
\usage{
get_statistic(x, ...)

\method{get_statistic}{default}(x, column_index = 3, verbose = TRUE, ...)

\method{get_statistic}{glmmTMB}(x, component = "all", ...)

\method{get_statistic}{emmGrid}(x, ci = 0.95, adjust = "none", merge_parameters = FALSE, ...)

\method{get_statistic}{gee}(x, robust = FALSE, ...)
}
\arguments{
\item{x}{A model.}

\item{...}{Currently not used.}

\item{column_index}{For model objects that have no defined
\code{get_statistic()} method yet, the default method is called. This
method tries to extract the statistic column from \code{coef(summary())},
where the index of the column that is being pulled is \code{column_index}.
Defaults to 3, which is the default statistic column for most models'
summary-output.}

\item{verbose}{Toggle messages and warnings.}

\item{component}{String, indicating the model component for which parameters
should be returned. The default for all models is \code{"all"}, which returns
the requested information for all available model components. Furthermore,
there are specific options depending on the model class. \code{component} then
may be one of:
\itemize{
\item For zero-inflated models (\code{gmmTMB}, \code{hurdle}, \code{zeroinfl}, ...) can also
be \code{"conditional"} or \code{"zero-inflated"}. Note that the \emph{conditional}
component is also called \emph{count} or \emph{mean} component, depending on the
model. \code{glmmTMB} also has a \code{"dispersion"} component.
\item For models with smooth terms, \code{component = "smooth_terms"} returns the
test statistic for the smooth terms.
\item For models of class \code{mhurdle}, may also be one of  \code{"conditional"},
\code{"zero_inflated"}, \code{"infrequent_purchase"} or \code{"auxiliary"}.
\item For models of class \code{clm2} or \code{clmm2}, may also be \code{"scale"}.
\item For models of class \code{betareg}, \code{betaor} or \code{betamfx}, may also be
\code{"precision"}. For other \verb{*mfx} models (\code{logitmfx}, \code{betamfx}, ...),
may also be \code{"marginal"}.
\item For models of class \code{mvord}, may also be \code{"thresholds"} or
\code{"correlation"}.
\item For models of class \code{selection}, may also be \code{"selection"}, \code{"outcome"}
or \code{"auxiliary"}.
\item For models of class \code{glmx}, may also be \code{"extra"}.
\item For models of class \code{averaging}, may also be \code{"full"}.
}}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).
Currently only applies to objects of class \code{emmGrid}.}

\item{adjust}{Character value naming the method used to adjust p-values or
confidence intervals. See \code{?emmeans::summary.emmGrid} for details.}

\item{merge_parameters}{Logical, if \code{TRUE} and \code{x} has multiple columns for
parameter names (like \code{emmGrid} objects may have), these are merged into a
single parameter column, with parameters names and values as values.}

\item{robust}{Logical, if \code{TRUE}, test statistic based on robust
standard errors is returned.}
}
\value{
A data frame with the model's parameter names and the related test
statistic.
}
\description{
Returns the statistic (\emph{t}, \code{z}, ...) for model
estimates. In most cases, this is the related column from
\code{coef(summary())}.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_statistic(m)
}
