% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comment_linters.R
\name{todo_comment_linter}
\alias{todo_comment_linter}
\title{TODO comment linter}
\usage{
todo_comment_linter(todo = c("todo", "fixme"))
}
\arguments{
\item{todo}{Vector of strings that identify TODO comments.}
}
\description{
Check that the source contains no TODO comments (case-insensitive).
}
\examples{
# will produce lints
lint(
  text = "x + y # TODO",
  linters = todo_comment_linter()
)

lint(
  text = "pi <- 1.0 # FIXME",
  linters = todo_comment_linter()
)

lint(
  text = "x <- TRUE # hack",
  linters = todo_comment_linter(todo = c("todo", "fixme", "hack"))
)

# okay
lint(
  text = "x + y # my informative comment",
  linters = todo_comment_linter()
)

lint(
  text = "pi <- 3.14",
  linters = todo_comment_linter()
)

lint(
  text = "x <- TRUE",
  linters = todo_comment_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=style_linters]{style}
}
