% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison_negation_linter.R
\name{comparison_negation_linter}
\alias{comparison_negation_linter}
\title{Block usages like !(x == y) where a direct relational operator is appropriate}
\usage{
comparison_negation_linter()
}
\description{
\code{!(x == y)} is more readably expressed as \code{x != y}. The same is true of
other negations of simple comparisons like \code{!(x > y)} and \code{!(x <= y)}.
}
\examples{
# will produce lints
lint(
  text = "!x == 2",
  linters = comparison_negation_linter()
)

lint(
  text = "!(x > 2)",
  linters = comparison_negation_linter()
)

# okay
lint(
  text = "!(x == 2 & y > 2)",
  linters = comparison_negation_linter()
)

lint(
  text = "!(x & y)",
  linters = comparison_negation_linter()
)

lint(
  text = "x != 2",
  linters = comparison_negation_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=consistency_linters]{consistency}, \link[=readability_linters]{readability}
}
