#' Liver pathology data
#'
#' @details These data have the results of a _x_-ray examination
#'  to determine whether liver is abnormal or not (in the `scan`
#'  column) versus the more extensive pathology results that
#'  approximate the truth (in `pathology`).
#'
#' @name pathology
#' @aliases pathology
#' @docType data
#' @return \item{pathology}{a data frame}
#'
#' @source Altman, D.G., Bland, J.M. (1994) ``Diagnostic tests 1:
#'  sensitivity and specificity,'' *British Medical Journal*,
#'  vol 308, 1552.
#'
#'
#' @keywords datasets
#' @examples
#' data(pathology)
#' str(pathology)
NULL

