% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanoperiod.R
\name{all.equal.nanoperiod}
\alias{all.equal.nanoperiod}
\alias{all.equal,nanoperiod-method}
\title{Test if Two Objects are (Nearly) Equal}
\usage{
\method{all.equal}{nanoperiod}(target, current, ..., check.attributes = TRUE)

\S4method{all.equal}{nanoperiod}(target, current, ..., check.attributes = TRUE)
}
\arguments{
\item{target, current}{\code{nanoperiod} arguments to be compared}

\item{...}{further arguments for different methods}

\item{check.attributes}{logical indicating if the
\code{attributes} of \code{target} and \code{current} (other than
the names) should be compared.}
}
\description{
Compare \code{target} and \code{current} testing \sQuote{near
equality}.  If they are different, comparison is still made to
some extent, and a report of the differences is returned.  Do not
use \code{all.equal} directly in \code{if} expressions---either
use \code{isTRUE(all.equal(....))} or \code{\link{identical}} if
appropriate.
}
\seealso{
\code{\link{identical}}, \code{\link{isTRUE}},
    \code{\link{==}}, and \code{\link{all}} for exact equality
    testing.
}
