% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_workbook.R
\name{buildWorkbook}
\alias{buildWorkbook}
\title{Build Workbook}
\usage{
buildWorkbook(x, asTable = FALSE, ...)
}
\arguments{
\item{x}{A data.frame or a (named) list of objects that can be handled by
\code{\link[=writeData]{writeData()}} or \code{\link[=writeDataTable]{writeDataTable()}} to write to file}

\item{asTable}{If \code{TRUE} will use \code{\link[=writeDataTable]{writeDataTable()}} rather
than \code{\link[=writeData]{writeData()}} to write \code{x} to the file (default:
\code{FALSE})}

\item{...}{Additional arguments passed to \code{\link[=writeData]{writeData()}},
\code{\link[=writeDataTable]{writeDataTable()}}, \code{\link[=setColWidths]{setColWidths()}} (see Optional
Parameters)}
}
\value{
A Workbook object
}
\description{
Build a workbook from a data.frame or named list
}
\details{
This function can be used as shortcut to create a workbook object from a
data.frame or named list.  If names are available in the list they will be
used as the worksheet names.  The parameters in \code{...} are collected
and passed to \code{\link[=writeData]{writeData()}} or \code{\link[=writeDataTable]{writeDataTable()}} to
initially create the Workbook objects then appropriate parameters are
passed to \code{\link[=setColWidths]{setColWidths()}}.

columns of x with class Date or POSIXt are automatically
styled as dates and datetimes respectively.
}
\section{Optional Parameters}{


\strong{createWorkbook Parameters}
\itemize{
\item{\strong{creator}}{ A string specifying the workbook author}
}

\strong{addWorksheet Parameters}
\itemize{
\item{\strong{sheetName}}{ Name of the worksheet}
\item{\strong{gridLines}}{ A logical. If \code{FALSE}, the worksheet grid lines will be hidden.}
\item{\strong{tabColour}}{ Colour of the worksheet tab. A valid colour (belonging to colours())
or a valid hex colour beginning with "#".}
\item{\strong{zoom}}{ A numeric between 10 and 400. Worksheet zoom level as a percentage.}
}

\strong{writeData/writeDataTable Parameters}
\itemize{
\item{\strong{startCol}}{ A vector specifying the starting column(s) to write df}
\item{\strong{startRow}}{ A vector specifying the starting row(s) to write df}
\item{\strong{xy}}{ An alternative to specifying startCol and startRow individually.
A vector of the form c(startCol, startRow)}
\item{\strong{colNames or col.names}}{ If \code{TRUE}, column names of x are written.}
\item{\strong{rowNames or row.names}}{ If \code{TRUE}, row names of x are written.}
\item{\strong{headerStyle}}{ Custom style to apply to column names.}
\item{\strong{borders}}{ Either "surrounding", "columns" or "rows" or NULL.  If "surrounding", a border is drawn around the
data.  If "rows", a surrounding border is drawn a border around each row. If "columns", a surrounding border is drawn with a border
between each column.  If "\code{all}" all cell borders are drawn.}
\item{\strong{borderColour}}{ Colour of cell border}
\item{\strong{borderStyle}}{ Border line style.}
\item{\strong{keepNA}} {If \code{TRUE}, NA values are converted to #N/A (or \code{na.string}, if not NULL) in Excel, else NA cells will be empty. Defaults to FALSE.}
\item{\strong{na.string}} {If not NULL, and if \code{keepNA} is \code{TRUE}, NA values are converted to this string in Excel. Defaults to NULL.}
}

\strong{freezePane Parameters}
\itemize{
\item{\strong{firstActiveRow}} {Top row of active region to freeze pane.}
\item{\strong{firstActiveCol}} {Furthest left column of active region to freeze pane.}
\item{\strong{firstRow}} {If \code{TRUE}, freezes the first row (equivalent to firstActiveRow = 2)}
\item{\strong{firstCol}} {If \code{TRUE}, freezes the first column (equivalent to firstActiveCol = 2)}
}

\strong{colWidths Parameters}
\itemize{
\item{\strong{colWidths}} {May be a single value for all columns (or "auto"), or a list of vectors that will be recycled for each sheet (see examples)}
}
}

\examples{
x <- data.frame(a = 1, b = 2)
wb <- buildWorkbook(x)

y <- list(a = x, b = x, c = x)
buildWorkbook(y, asTable = TRUE)
buildWorkbook(y, asTable = TRUE, tableStyle = "TableStyleLight8")

}
\seealso{
\code{\link[=write.xlsx]{write.xlsx()}}
}
\author{
Jordan Mark Barbone
}
