% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{get_worksheet_entries}
\alias{get_worksheet_entries}
\title{Get entries from workbook worksheet}
\usage{
get_worksheet_entries(wb, sheet)
}
\arguments{
\item{wb}{workbook}

\item{sheet}{worksheet}
}
\value{
vector of strings
}
\description{
Get all entries from workbook worksheet without xml tags
}
\examples{
## Create new workbook
wb <- createWorkbook()
addWorksheet(wb, "Sheet")
sheet <- 1

## Write dummy data
writeData(wb, sheet, c("A", "BB", "CCC"), startCol = 2, startRow = 3)
writeData(wb, sheet, c(4, 5), startCol = 4, startRow = 3)

## Get text entries
get_worksheet_entries(wb, sheet)

}
\author{
David Breuer
}
