% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{removeColWidths}
\alias{removeColWidths}
\title{Remove column widths from a worksheet}
\usage{
removeColWidths(wb, sheet, cols)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{cols}{Indices of columns to remove custom width (if any) from.}
}
\description{
Remove column widths from a worksheet
}
\examples{
## Create a new workbook
wb <- loadWorkbook(file = system.file("extdata", "loadExample.xlsx", package = "openxlsx"))

## remove column widths in columns 1 to 20
removeColWidths(wb, 1, cols = 1:20)
\dontrun{
saveWorkbook(wb, "removeColWidthsExample.xlsx", overwrite = TRUE)
}
}
\seealso{
\code{\link[=setColWidths]{setColWidths()}}
}
\author{
Alexander Walker
}
