% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_zmq_message.r
\name{Message Function}
\alias{Message Function}
\alias{zmq.msg.send}
\alias{zmq.msg.recv}
\title{Message Functions}
\usage{
zmq.msg.send(
  rmsg,
  socket,
  flags = .pbd_env$ZMQ.SR$BLOCK,
  serialize = TRUE,
  serialversion = NULL
)

zmq.msg.recv(socket, flags = .pbd_env$ZMQ.SR$BLOCK, unserialize = TRUE)
}
\arguments{
\item{rmsg}{an R message}

\item{socket}{a ZMQ socket}

\item{flags}{a flag for method of send and receive}

\item{serialize}{if serialize the \code{rmsg}}

\item{serialversion}{NULL or numeric; the workspace format version to use when serializing.
NULL specifies the current default version. The only other supported
values are 2 and 3}

\item{unserialize}{if unserialize the received R message}
}
\value{
\code{zmq.msg.send()} returns 0 if successful, otherwise returns -1
and sets \code{errno} to \code{EFAULT}.

\code{zmq.msg.recv()} returns the message if successful, otherwise returns
-1 and sets \code{errno} to \code{EFAULT}.
}
\description{
Message functions
}
\details{
\code{zmq.msg.send()} sends an R message.

\code{zmq.msg.recv()} receives an R message.
}
\examples{
\dontrun{
### Using request-reply pattern.

### At the server, run next in background or the other window.
library(pbdZMQ, quietly = TRUE)

context <- zmq.ctx.new()
responder <- zmq.socket(context, .pbd_env$ZMQ.ST$REP)
zmq.bind(responder, "tcp://*:5555")
buf <- zmq.msg.recv(responder)
set.seed(1234)
ret <- rnorm(5)
print(ret)
zmq.msg.send(ret, responder)
zmq.close(responder)
zmq.ctx.destroy(context)


### At a client, run next in foreground.
library(pbdZMQ, quietly = TRUE)

context <- zmq.ctx.new()
requester <- zmq.socket(context, .pbd_env$ZMQ.ST$REQ)
zmq.connect(requester, "tcp://localhost:5555")
zmq.msg.send(NULL, requester)
ret <- zmq.msg.recv(requester)
print(ret)
zmq.close(requester)
zmq.ctx.destroy(context)
}

}
\references{
ZeroMQ/4.1.0 API Reference:
\url{http://api.zeromq.org/4-1:_start}

Programming with Big Data in R Website: \url{https://pbdr.org/}
}
\seealso{
\code{\link{zmq.send}()}, \code{\link{zmq.recv}()}.
}
\author{
Wei-Chen Chen \email{wccsnow@gmail.com}.
}
\keyword{programming}
