% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictRestrictedMeanTime.R
\name{predictRestrictedMeanTime}
\alias{predictRestrictedMeanTime}
\alias{predictRestrictedMeanTime.aalen}
\alias{predictRestrictedMeanTime.riskRegression}
\alias{predictRestrictedMeanTime.cox.aalen}
\alias{predictRestrictedMeanTime.coxph}
\alias{predictRestrictedMeanTime.cph}
\alias{predictRestrictedMeanTime.default}
\alias{predictRestrictedMeanTime.rfsrc}
\alias{predictRestrictedMeanTime.matrix}
\alias{predictRestrictedMeanTime.pecCtree}
\alias{predictRestrictedMeanTime.prodlim}
\alias{predictRestrictedMeanTime.psm}
\alias{predictRestrictedMeanTime.selectCox}
\alias{predictRestrictedMeanTime.survfit}
\alias{predictRestrictedMeanTime.pecRpart}
\title{Predicting restricted mean time}
\usage{
\method{predictRestrictedMeanTime}{aalen}(object,newdata,times,...)
\method{predictRestrictedMeanTime}{riskRegression}(object,newdata,times,...)
\method{predictRestrictedMeanTime}{cox.aalen}(object,newdata,times,...)
\method{predictRestrictedMeanTime}{cph}(object,newdata,times,...)
\method{predictRestrictedMeanTime}{coxph}(object,newdata,times,...)
\method{predictRestrictedMeanTime}{matrix}(object,newdata,times,...)
\method{predictRestrictedMeanTime}{selectCox}(object,newdata,times,...)
\method{predictRestrictedMeanTime}{prodlim}(object,newdata,times,...)
\method{predictRestrictedMeanTime}{psm}(object,newdata,times,...)
\method{predictRestrictedMeanTime}{survfit}(object,newdata,times,...)
\method{predictRestrictedMeanTime}{pecRpart}(object,newdata,times,...)
#' \method{predictRestrictedMeanTime}{pecCtree}(object,newdata,times,...)
}
\arguments{
\item{object}{A fitted model from which to extract predicted survival
probabilities}

\item{newdata}{A data frame containing predictor variable combinations for
which to compute predicted survival probabilities.}

\item{times}{A vector of times in the range of the response variable, e.g.
times when the response is a survival object, at which to return the
survival probabilities.}

\item{\dots}{Additional arguments that are passed on to the current method.}
}
\value{
A matrix with as many rows as \code{NROW(newdata)} and as many
columns as \code{length(times)}. Each entry should be a probability and in
rows the values should be decreasing.
}
\description{
Function to extract predicted mean times from various modeling
approaches.
}
\details{
The function predictRestrictedMeanTime is a generic function, meaning that it
invokes a different function dependent on the 'class' of the
first argument. 

See also \code{\link{predictSurvProb}}.
}
\note{
In order to assess the predictive performance of a new survival model
a specific \code{predictRestrictedMeanTime} S3 method has to be written. For examples,
see the bodies of the existing methods.

The performance of the assessment procedure, in particular for resampling
where the model is repeatedly evaluated, will be improved by supressing in
the call to the model all the computations that are not needed for
probability prediction. For example, \code{se.fit=FALSE} can be set in the
call to \code{cph}.
}
\examples{

# generate some survival data
library(prodlim)
set.seed(100)
d <- SimSurv(100)
# then fit a Cox model
library(rms)
coxmodel <- cph(Surv(time,status)~X1+X2,data=d,surv=TRUE)

# predicted survival probabilities can be extracted
# at selected time-points:
ttt <- quantile(d$time)
# for selected predictor values:
ndat <- data.frame(X1=c(0.25,0.25,-0.05,0.05),X2=c(0,1,0,1))
# as follows
predictRestrictedMeanTime(coxmodel,newdata=ndat,times=ttt)

# stratified cox model
sfit <- coxph(Surv(time,status)~strata(X1)+X2,data=d,x=TRUE,y=TRUE)
predictRestrictedMeanTime(sfit,newdata=d[1:3,],times=c(1,3,5,10))

## simulate some learning and some validation data
learndat <- SimSurv(100)
valdat <- SimSurv(100)
## use the learning data to fit a Cox model
library(survival)
fitCox <- coxph(Surv(time,status)~X1+X2,data=learndat,x=TRUE,y=TRUE)
## suppose we want to predict the survival probabilities for all patients
## in the validation data at the following time points:
## 0, 12, 24, 36, 48, 60
psurv <- predictRestrictedMeanTime(fitCox,newdata=valdat,times=seq(0,60,12))
## This is a matrix with survival probabilities
## one column for each of the 5 time points
## one row for each validation set individual

# the same can be done e.g. for a randomSurvivalForest model
library(randomForestSRC)
rsfmodel <- rfsrc(Surv(time,status)~X1+X2,data=d)
predictRestrictedMeanTime(rsfmodel,newdata=ndat,times=ttt)
}
\references{
Ulla B. Mogensen, Hemant Ishwaran, Thomas A. Gerds (2012).
Evaluating Random Forests for Survival Analysis Using Prediction Error
Curves. Journal of Statistical Software, 50(11), 1-23. DOI
10.18637/jss.v050.i11
}
\seealso{
\code{\link{predict}},\code{\link{survfit}}
}
\author{
Thomas A. Gerds \email{tag@biostat.ku.dk}
}
\keyword{survival}
