% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.bayesian.R
\name{model_performance.stanreg}
\alias{model_performance.stanreg}
\alias{model_performance.BFBayesFactor}
\title{Performance of Bayesian Models}
\usage{
\method{model_performance}{stanreg}(model, metrics = "all", verbose = TRUE, ...)

\method{model_performance}{BFBayesFactor}(
  model,
  metrics = "all",
  verbose = TRUE,
  average = FALSE,
  prior_odds = NULL,
  ...
)
}
\arguments{
\item{model}{Object of class \code{stanreg} or \code{brmsfit}.}

\item{metrics}{Can be \code{"all"}, \code{"common"} or a character vector of
metrics to be computed (some of \code{c("LOOIC", "WAIC", "R2", "R2_adj", "RMSE", "SIGMA", "LOGLOSS", "SCORE")}). \code{"common"} will compute LOOIC,
WAIC, R2 and RMSE.}

\item{verbose}{Toggle off warnings.}

\item{...}{Arguments passed to or from other methods.}

\item{average}{Compute model-averaged index? See \code{\link[bayestestR:weighted_posteriors]{bayestestR::weighted_posteriors()}}.}

\item{prior_odds}{Optional vector of prior odds for the models compared to
the first model (or the denominator, for \code{BFBayesFactor} objects). For
\code{data.frame}s, this will be used as the basis of weighting.}
}
\value{
A data frame (with one row) and one column per "index" (see
\code{metrics}).
}
\description{
Compute indices of model performance for (general) linear models.
}
\details{
Depending on \code{model}, the following indices are computed:
\itemize{
\item \strong{ELPD}: expected log predictive density. Larger ELPD values
mean better fit. See \code{\link[=looic]{looic()}}.
\item \strong{LOOIC}: leave-one-out cross-validation (LOO) information
criterion. Lower LOOIC values mean better fit. See \code{\link[=looic]{looic()}}.
\item \strong{WAIC}: widely applicable information criterion. Lower WAIC
values mean better fit. See \code{?loo::waic}.
\item \strong{R2}: r-squared value, see \code{\link[=r2_bayes]{r2_bayes()}}.
\item \strong{R2_adjusted}: LOO-adjusted r-squared, see \code{\link[=r2_loo]{r2_loo()}}.
\item \strong{RMSE}: root mean squared error, see \code{\link[=performance_rmse]{performance_rmse()}}.
\item \strong{SIGMA}: residual standard deviation, see \code{\link[insight:get_sigma]{insight::get_sigma()}}.
\item \strong{LOGLOSS}: Log-loss, see \code{\link[=performance_logloss]{performance_logloss()}}.
\item \strong{SCORE_LOG}: score of logarithmic proper scoring rule, see \code{\link[=performance_score]{performance_score()}}.
\item \strong{SCORE_SPHERICAL}: score of spherical proper scoring rule, see \code{\link[=performance_score]{performance_score()}}.
\item \strong{PCP}: percentage of correct predictions, see \code{\link[=performance_pcp]{performance_pcp()}}.
}
}
\examples{
\dontshow{if (require("rstanarm") && require("rstantools") && require("BayesFactor")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
model <- suppressWarnings(rstanarm::stan_glm(
  mpg ~ wt + cyl,
  data = mtcars,
  chains = 1,
  iter = 500,
  refresh = 0
))
model_performance(model)

model <- suppressWarnings(rstanarm::stan_glmer(
  mpg ~ wt + cyl + (1 | gear),
  data = mtcars,
  chains = 1,
  iter = 500,
  refresh = 0
))
model_performance(model)

model <- BayesFactor::generalTestBF(carb ~ am + mpg, mtcars)

model_performance(model)
model_performance(model[3])
model_performance(model, average = TRUE)
}
\dontshow{\}) # examplesIf}
}
\references{
Gelman, A., Goodrich, B., Gabry, J., and Vehtari, A. (2018).
R-squared for Bayesian regression models. The American Statistician, The
American Statistician, 1-6.
}
\seealso{
\link{r2_bayes}
}
