% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_rmse.R
\name{performance_rmse}
\alias{performance_rmse}
\alias{rmse}
\title{Root Mean Squared Error}
\usage{
performance_rmse(model, normalized = FALSE, verbose = TRUE)

rmse(model, normalized = FALSE, verbose = TRUE)
}
\arguments{
\item{model}{A model.}

\item{normalized}{Logical, use \code{TRUE} if normalized rmse should be returned.}

\item{verbose}{Toggle off warnings.}
}
\value{
Numeric, the root mean squared error.
}
\description{
Compute root mean squared error for (mixed effects) models,
including Bayesian regression models.
}
\details{
The RMSE is the square root of the variance of the residuals and indicates
the absolute fit of the model to the data (difference between observed data
to model's predicted values). It can be interpreted as the standard
deviation of the unexplained variance, and is in the same units as the
response variable. Lower values indicate better model fit.

The normalized RMSE is the proportion of the RMSE related to the
range of the response variable. Hence, lower values indicate
less residual variance.
}
\examples{
\dontshow{if (require("nlme")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Orthodont, package = "nlme")
m <- nlme::lme(distance ~ age, data = Orthodont)

# RMSE
performance_rmse(m, normalized = FALSE)

# normalized RMSE
performance_rmse(m, normalized = TRUE)
\dontshow{\}) # examplesIf}
}
