% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathjax.R
\name{TeX}
\alias{TeX}
\title{Render TeX in a plotly graph using MathJax}
\usage{
TeX(x)
}
\arguments{
\item{x}{a character vector}
}
\description{
This function makes it slightly easier to render TeX in a plotly graph --
it ensures that MathJax is included with the final result and also
ensures the provided string is surrounded with \code{$} (this is what plotly.js
uses to declare a string as TeX).
}
\examples{
\dontshow{if (interactive() || !identical(.Platform$OS.type, "windows")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

plot_ly(x = c(1, 2, 3, 4), y = c(1, 4, 9, 16)) \%>\%
  layout(title = TeX("\\\\text{Some mathjax: }\\\\alpha+\\\\beta x")) \%>\%
  config(mathjax = "cdn")
\dontshow{\}) # examplesIf}
}
\seealso{
\link{config}
}
