% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_bundles.R
\name{partial_bundle}
\alias{partial_bundle}
\title{Use a partial bundle of plotly.js}
\usage{
partial_bundle(p, type = "auto", local = TRUE, minified = TRUE)
}
\arguments{
\item{p}{a plotly object.}

\item{type}{name of the (partial) bundle. The default, \code{'auto'}, attempts to
find the smallest single bundle that can render \code{p}. If no single partial bundle
can render \code{p}, then the full bundle is used.}

\item{local}{whether or not to download the partial bundle so that it can be
viewed later without an internet connection.}

\item{minified}{whether or not to use a minified js file (non-minified file can be useful for debugging plotly.js)}
}
\description{
Leveraging plotly.js' partial bundles can lead to smaller file sizes
and faster rendering. The full list of available bundles, and the
trace types that they support, are available
\href{https://github.com/plotly/plotly.js/blob/master/dist/README.md#partial-bundles}{here}
}
\details{
WARNING: use this function with caution when rendering multiple
plotly graphs on a single website. That's because, if multiple plotly.js
bundles are used, the most recent bundle will override the other bundles.
See the examples section for an example.
}
\examples{
\dontshow{if (interactive() || !identical(.Platform$OS.type, "windows")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# ----------------------------------------------------------------------
# This function is always safe to use when rendering a single 
# plotly graph. In this case, we get a 3x file reduction.
# ----------------------------------------------------------------------

\dontrun{
library(plotly)
p <- plot_ly(x = 1:10, y = 1:10) \%>\% add_markers()
save_widget <- function(p, f) {
  owd <- setwd(dirname(f))
  on.exit(setwd(owd))
  htmlwidgets::saveWidget(p, f)
  mb <- round(file.info(f)$size / 1e6, 3)
  message("File is: ", mb," MB")
}
f1 <- tempfile(fileext = ".html")
f2 <- tempfile(fileext = ".html")
save_widget(p, f1)
save_widget(partial_bundle(p), f2)

# ----------------------------------------------------------------------
# But, since plotly.js bundles override one another, 
# be careful when putting multiple graphs in a larger document!
# Note how the surface (part of the gl3d bundle) renders, but the 
# heatmap (part of the cartesian bundle) doesn't...
# ----------------------------------------------------------------------

library(htmltools)
p1 <- plot_ly(z = ~volcano) \%>\% 
  add_heatmap() \%>\%
  partial_bundle()
p2 <- plot_ly(z = ~volcano) \%>\% 
  add_surface() \%>\%
  partial_bundle()
browsable(tagList(p1, p2))
}
\dontshow{\}) # examplesIf}
}
\author{
Carson Sievert
}
