% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe.R
\name{pipes}
\alias{pipes}
\alias{\%...>\%}
\alias{\%...T>\%}
\alias{\%...!\%}
\alias{\%...T!\%}
\title{Promise pipe operators}
\usage{
lhs \%...>\% rhs

lhs \%...T>\% rhs

lhs \%...!\% rhs

lhs \%...T!\% rhs
}
\arguments{
\item{lhs}{A promise object.}

\item{rhs}{A function call using the magrittr semantics. It can return either
a promise or non-promise value, or throw an error.}
}
\value{
A new promise.
}
\description{
Promise-aware pipe operators, in the style of \href{https://CRAN.R-project.org/package=magrittr/vignettes/magrittr.html}{magrittr}.
Like magrittr pipes, these operators can be used to chain together pipelines
of promise-transforming operations. Unlike magrittr pipes, these pipes wait
for promise resolution and pass the unwrapped value (or error) to the \code{rhs}
function call.
}
\details{
The \code{>} variants are for handling successful resolution, the \code{!} variants are
for handling errors. The \code{T} variants of each return the lhs instead of the
rhs, which is useful for pipeline steps that are used for side effects
(printing, plotting, saving).
\enumerate{
\item \code{promise \%...>\% func()} is equivalent to \code{promise \%>\% then(func)}.
\item \code{promise \%...!\% func()} is equivalent to \code{promise \%>\% catch(func)}.
\item \code{promise \%...T>\% func()} is equivalent to \code{promise \%T>\% then(func)}.
\item \code{promise \%...T!\% func()} is equivalent to \code{promise \%T>\%
catch(func)} or \code{promise \%>\% catch(func, tee = TRUE)}.
}

One situation where 3. and 4. above break down is when \code{func()} throws an
error, or returns a promise that ultimately fails. In that case, the failure
will be propagated by our pipe operators but not by the
magrittr-plus-function "equivalents".

For simplicity of implementation, we do not support the magrittr feature of
using a \code{.} at the head of a pipeline to turn the entire pipeline into a
function instead of an expression.
}
\examples{
\donttest{
library(future)
plan(multisession)

future(cars) \%...>\%
  head(5) \%...T>\%
  print()

# If the read.csv fails, resolve to NULL instead
future(read.csv("http://example.com/data.csv")) \%...!\%
  { NULL }
}

}
\seealso{
https://rstudio.github.io/promises/articles/overview.html#using-pipes
}
