% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{regressor_coefficients}
\alias{regressor_coefficients}
\title{Summarise the coefficients of the extra regressors used in the model.
For additive regressors, the coefficient represents the incremental impact
on \code{y} of a unit increase in the regressor. For multiplicative regressors,
the incremental impact is equal to \code{trend(t)} multiplied by the coefficient.}
\usage{
regressor_coefficients(m)
}
\arguments{
\item{m}{Prophet model object, after fitting.}
}
\value{
Dataframe with one row per regressor.
}
\description{
Coefficients are measured on the original scale of the training data.
}
\details{
Output dataframe columns:
\itemize{
  \item{regressor: Name of the regressor}
  \item{regressor_mode: Whether the regressor has an additive or multiplicative
effect on \code{y}.}
  \item{center: The mean of the regressor if it was standardized. Otherwise 0.}
  \item{coef_lower: Lower bound for the coefficient, estimated from the MCMC samples.
    Only different to \code{coef} if \code{mcmc_samples > 0}.
  }
  \item{coef: Expected value of the coefficient.}
  \item{coef_upper: Upper bound for the coefficient, estimated from MCMC samples.
    Only to different to \code{coef} if \code{mcmc_samples > 0}.
  }
}
}
