% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{check_class}
\alias{check_class}
\title{Check variable class}
\usage{
check_class(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  class_nm = NULL,
  allow_additional = FALSE,
  skip = FALSE,
  class_list = NULL,
  id = rand_id("class")
)
}
\arguments{
\item{recipe}{A recipe object. The check will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this check. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this check since no new variables are
created.}

\item{trained}{A logical for whether the selectors in \code{...}
have been resolved by \code{\link[=prep]{prep()}}.}

\item{class_nm}{A character vector that will be used in \code{inherits} to
check the class. If \code{NULL} the classes will be learned in \code{prep}.
Can contain more than one class.}

\item{allow_additional}{If \code{TRUE} a variable is allowed to
have additional classes to the one(s) that are checked.}

\item{skip}{A logical. Should the check be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{class_list}{A named list of column classes. This is
\code{NULL} until computed by \code{\link[=prep]{prep()}}.}

\item{id}{A character string that is unique to this check to identify it.}
}
\value{
An updated version of \code{recipe} with the new check added to the
sequence of any existing operations.
}
\description{
\code{check_class} creates a \emph{specification} of a recipe
check that will check if a variable is of a designated class.
}
\details{
This function can check the classes of the variables
in two ways. When the \code{class} argument is provided
it will check if all the variables specified are of the
given class. If this argument is \code{NULL}, the check will
learn the classes of each of the specified variables in \code{prep}.
Both ways will break \code{bake} if the variables are not of
the requested class. If a variable has multiple
classes in \code{prep}, all the classes are checked. Please note
that in \code{prep} the argument \code{strings_as_factors} defaults to
\code{TRUE}. If the train set contains character variables
the check will be break \code{bake} when \code{strings_as_factors} is
\code{TRUE}.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this check, a tibble with columns
\code{terms} (the selectors or variables selected) and \code{value} (the type)
is returned.
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)
data(Sacramento, package = "modeldata")

# Learn the classes on the train set
train <- Sacramento[1:500, ]
test <- Sacramento[501:nrow(Sacramento), ]
recipe(train, sqft ~ .) \%>\%
  check_class(everything()) \%>\%
  prep(train, strings_as_factors = FALSE) \%>\%
  bake(test)

# Manual specification
recipe(train, sqft ~ .) \%>\%
  check_class(sqft, class_nm = "integer") \%>\%
  check_class(city, zip, type, class_nm = "factor") \%>\%
  check_class(latitude, longitude, class_nm = "numeric") \%>\%
  prep(train, strings_as_factors = FALSE) \%>\%
  bake(test)

# By default only the classes that are specified
#   are allowed.
x_df <- tibble(time = c(Sys.time() - 60, Sys.time()))
x_df$time \%>\% class()
\dontrun{
recipe(x_df) \%>\%
  check_class(time, class_nm = "POSIXt") \%>\%
  prep(x_df) \%>\%
  bake_(x_df)
}

# Use allow_additional = TRUE if you are fine with it
recipe(x_df) \%>\%
  check_class(time, class_nm = "POSIXt", allow_additional = TRUE) \%>\%
  prep(x_df) \%>\%
  bake(x_df)
\dontshow{\}) # examplesIf}
}
\seealso{
Other checks: 
\code{\link{check_cols}()},
\code{\link{check_missing}()},
\code{\link{check_new_values}()},
\code{\link{check_range}()}
}
\concept{checks}
