% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_roll.R
\name{step_impute_roll}
\alias{step_impute_roll}
\title{Impute numeric data using a rolling window statistic}
\usage{
step_impute_roll(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  statistic = median,
  window = 5,
  skip = FALSE,
  id = rand_id("impute_roll")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables to be imputed;
these columns must be non-integer numerics (i.e., double precision).
See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[=prep]{prep()}} is used.}

\item{statistic}{A function with a single argument for the data to compute
the imputed value. Only complete values will be passed to the function and
it should return a double precision value.}

\item{window}{The size of the window around a point to be imputed. Should be
an odd integer greater than one. See Details below for a discussion of
points at the ends of the series.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_impute_roll()} creates a \emph{specification} of a recipe step that will
substitute missing values of numeric variables by the measure of location
(e.g. median) within a moving window.
}
\details{
On the tails, the window is shifted towards the ends.
For example, for a 5-point window, the windows for the first
four points are \code{1:5}, \code{1:5}, \code{1:5}, and then \code{2:6}.

When missing data are in the window, they are not passed to the
function. If all of the data in the window are missing, a
missing value is returned.

The statistics are calculated on the training set values
\emph{before} imputation. This means that if previous data within the
window are missing, their imputed values are not included in the
window data used for imputation. In other words, each imputation
does not know anything about previous imputations in the series
prior to the current point.

As of \code{recipes} 0.1.16, this function name changed from \code{step_rollimpute()}
to \code{step_impute_roll()}.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{window} , and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{window}{integer, window size}
\item{id}{character, id of this step}
}
}

\section{Tuning Parameters}{
This step has 2 tuning parameters:
\itemize{
\item \code{statistic}: Rolling Summary Statistic (type: character, default: median)
\item \code{window}: Window Size (type: integer, default: 5)
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
library(lubridate)

set.seed(145)
example_data <-
  data.frame(
    day = ymd("2012-06-07") + days(1:12),
    x1 = round(runif(12), 2),
    x2 = round(runif(12), 2),
    x3 = round(runif(12), 2)
  )
example_data$x1[c(1, 5, 6)] <- NA
example_data$x2[c(1:4, 10)] <- NA

library(recipes)
seven_pt <- recipe(~., data = example_data) \%>\%
  update_role(day, new_role = "time_index") \%>\%
  step_impute_roll(all_numeric_predictors(), window = 7) \%>\%
  prep(training = example_data)

# The training set:
bake(seven_pt, new_data = NULL)
}
\seealso{
Other imputation steps: 
\code{\link{step_impute_bag}()},
\code{\link{step_impute_knn}()},
\code{\link{step_impute_linear}()},
\code{\link{step_impute_lower}()},
\code{\link{step_impute_mean}()},
\code{\link{step_impute_median}()},
\code{\link{step_impute_mode}()}

Other row operation steps: 
\code{\link{step_arrange}()},
\code{\link{step_filter}()},
\code{\link{step_lag}()},
\code{\link{step_naomit}()},
\code{\link{step_sample}()},
\code{\link{step_shuffle}()},
\code{\link{step_slice}()}
}
\concept{imputation steps}
\concept{row operation steps}
