% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repl.R
\name{repl_python}
\alias{repl_python}
\title{Run a Python REPL}
\usage{
repl_python(
  module = NULL,
  quiet = getOption("reticulate.repl.quiet", default = FALSE)
)
}
\arguments{
\item{module}{An (optional) Python module to be imported before
the REPL is launched.}

\item{quiet}{Boolean; print a startup banner when launching the REPL? If
\code{TRUE}, the banner will be suppressed.}
}
\description{
This function provides a Python REPL in the \R session, which can be used
to interactively run Python code. All code executed within the REPL is
run within the Python main module, and any generated Python objects will
persist in the Python session after the REPL is detached.
}
\details{
When working with R and Python scripts interactively, one can activate
the Python REPL with \code{repl_python()}, run Python code, and later run \code{exit}
to return to the \R console.
}
\examples{
\dontrun{

# enter the Python REPL, create a dictionary, and exit
repl_python()
dictionary = {'alpha': 1, 'beta': 2}
exit

# access the created dictionary from R
py$dictionary
# $alpha
# [1] 1
#
# $beta
# [1] 2

}

}
\seealso{
\link{py}, for accessing objects created using the Python REPL.
}
