% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifecycle-deprecated.R
\name{dots_splice}
\alias{dots_splice}
\title{Splice lists}
\usage{
dots_splice(
  ...,
  .ignore_empty = c("trailing", "none", "all"),
  .preserve_empty = FALSE,
  .homonyms = c("keep", "first", "last", "error"),
  .check_assign = FALSE
)
}
\arguments{
\item{...}{Arguments to collect in a list. These dots are
\link[=dyn-dots]{dynamic}.}

\item{.ignore_empty}{Whether to ignore empty arguments. Can be one
of \code{"trailing"}, \code{"none"}, \code{"all"}. If \code{"trailing"}, only the
last argument is ignored if it is empty.}

\item{.preserve_empty}{Whether to preserve the empty arguments that
were not ignored. If \code{TRUE}, empty arguments are stored with
\code{\link[=missing_arg]{missing_arg()}} values. If \code{FALSE} (the default) an error is
thrown when an empty argument is detected.}

\item{.homonyms}{How to treat arguments with the same name. The
default, \code{"keep"}, preserves these arguments. Set \code{.homonyms} to
\code{"first"} to only keep the first occurrences, to \code{"last"} to keep
the last occurrences, and to \code{"error"} to raise an informative
error and indicate what arguments have duplicated names.}

\item{.check_assign}{Whether to check for \verb{<-} calls. When \code{TRUE} a
warning recommends users to use \code{=} if they meant to match a
function parameter or wrap the \verb{<-} call in curly braces otherwise.
This ensures assignments are explicit.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{dots_splice()} is like \code{\link[=dots_list]{dots_list()}} but automatically splices
list inputs.
}
\keyword{internal}
