% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{return_from}
\alias{return_from}
\title{Jump to or from a frame}
\usage{
return_from(frame, value = NULL)
}
\arguments{
\item{frame}{An execution environment of a currently running
function.}

\item{value}{The return value.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}

While \code{\link[base:function]{base::return()}} can only return from the current local
frame, \code{return_from()} will return from any frame on the
current evaluation stack, between the global and the currently
active context.
}
\examples{
fn <- function() {
  g(current_env())
  "ignored"
}
g <- function(env) {
  h(env)
  "ignored"
}
h <- function(env) {
  return_from(env, "early return")
  "ignored"
}

fn()
}
\keyword{internal}
