% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load}
\alias{load}
\alias{load_pkgload}
\alias{load_installed}
\alias{load_source}
\title{Load package code}
\usage{
load_pkgload(path)

load_installed(path)

load_source(path)
}
\arguments{
\item{path}{Path to source package}
}
\description{
roxygen2 is a dynamic documentation system, which means it works with the
objects inside your package, not just the source code used to create them.
These functions offer various ways of loading your package to suit various
constraints:
\itemize{
\item \code{load_pkgload()} uses \code{pkgload::load_all()} to simulate package loading
as closely as we know how. It offers high fidelity handling of code that
uses S4, but requires that the package be compiled.
\item \code{load_source()} simulates package loading by attaching packages listed in
\code{Depends} and \code{Imports}, then sources all files in the \verb{R/} directory.
This was the default strategy used in roxygen2 6.0.0 and earlier;
it's primary advantage is that it does not need compilation.
\item \code{load_installed()} uses the installed version of the package. Use this
strategy if you have installed a development version of the package
already. This is the highest fidelity strategy, but requires work
outside of roxygen2.
}

You can change the default strategy for your function with roxygen2 \code{load}
option. Override the default off \code{pkgload} to use the \code{source} or
\code{installed} strategies:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Roxygen: list(load = "source")
}\if{html}{\out{</div>}}
}
