% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-SDMXFooterMessage.R, R/SDMXFooterMessage-methods.R
\docType{class}
\name{SDMXFooterMessage}
\alias{SDMXFooterMessage}
\alias{SDMXFooterMessage,SDMXFooterMessage-method}
\alias{SDMXFooterMessage-class}
\title{Class "SDMXFooterMessage"}
\usage{
SDMXFooterMessage(xmlObj)
}
\arguments{
\item{xmlObj}{object of class "XMLInternalDocument derived from XML package}
}
\value{
an object of class "SDMXFooterMessage"
}
\description{
A basic class to handle a footer message of a SDMX-ML document
}
\section{Slots}{

\describe{
\item{\code{code}}{Object of class "character" giving the status code}

\item{\code{severity}}{Object of class "character" giving the severity of the message}

\item{\code{messages}}{Object of class "list" giving the list of messages}
}}
\note{
This class is especially useful for SDMX 2.1 compliant documents. Footer
messages are not supported in SDMX 2.0 standard format.

According to the SDMX 2.1 standard, the message severity takes one of the
following values: "Error", "Warning",Information". Given the possible typos
handled by data providers, rsdmx adopts a permissive strategy and does not
validate the object according to such controlled terms.
}
\section{Warning}{

This class is not useful in itself, but all SDMX non-abstract classes will
encapsulate it as slot, when parsing an SDMX-ML document
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
\seealso{
\link{SDMXFooter} \link{readSDMX}
}

