% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-SDMX.R, R/SDMX-methods.R
\docType{class}
\name{SDMX}
\alias{SDMX}
\alias{SDMX,SDMX-method}
\alias{SDMX-class}
\title{Class "SDMX"}
\usage{
SDMX(xmlObj, namespaces)
}
\arguments{
\item{xmlObj}{object of class "XMLInternalDocument derived from XML package}

\item{namespaces}{object of class "data.frame" given the list of namespace URIs}
}
\value{
an object of class "SDMX"
}
\description{
An abstract class from which SDMX classes are derived
}
\section{Slots}{

\describe{
\item{\code{xmlObj}}{Object of class "XMLInternalDocument" derived from XML package}

\item{\code{schema}}{Object of class "SDMXSchema", handles the version of SDMX-ML format}

\item{\code{header}}{Object of class "SDMXHeader", handles the SDMX-ML document header}

\item{\code{footer}}{Object of class "SDMXFooter", handles the SDMX-ML document footer}
}}
\note{
Currently, the approach drafted in \link{rsdmx} package was to rely on XML
 package, read the xml object and store it as part of the SDMX R object. Another
 approach being investigated is to use XML handlers throughthe Simple API for XML
 (SAX) that could avoid to load the full XML tree in the SDMX R object (xmlObj).
 Indeed, SDMX data could be huge and causes issues of memory if the complete XML
 tree is loaded in the R user session.
}
\section{Warning}{

This class is not useful in itself, but all SDMX classes in this package derive
from it.
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
\seealso{
\link{readSDMX}
}

