% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-example_model.R
\name{example_model}
\alias{example_model}
\title{Example model}
\format{Calling \code{example("example_model")} will run the model in the 
  Examples section, below, and the resulting stanreg object will then be
  available in the global environment. The \code{chains} and \code{iter}
  arguments are specified to make this example be small in size. In practice,
  we recommend that they be left unspecified in order to use the default
  values (4 and 2000 respectively) or increased if there are convergence
  problems. The \code{cores} argument is optional and on a multicore system,
  the user may well want to set that equal to the number of chains being
  executed.}
\description{
A model for use in \pkg{rstanarm} examples.
}
\examples{
example_model <- 
  stan_glmer(cbind(incidence, size - incidence) ~ size + period + (1|herd),
             data = lme4::cbpp, family = binomial, QR = TRUE,
             # this next line is only to keep the example small in size!
             chains = 2, cores = 1, seed = 12345, iter = 500, refresh = 0)
example_model
}
\seealso{
\code{\link[lme4]{cbpp}} for a description of the data.
}
