% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commands.R
\name{registerCommandStreamCallback}
\alias{registerCommandStreamCallback}
\title{Register Command Stream Callback}
\usage{
registerCommandStreamCallback(callback)
}
\arguments{
\item{callback}{A function to execute when the command is invoked.}
}
\value{
A handle representing the registration. Pass this handle
to \code{\link{unregisterCommandCallback}} to unregister the callback.
}
\description{
Registers a callback to be executed whenever any RStudio command is invoked.
}
\details{
The callback function will be given a single argument with the ID of the
command that was invoked. See the RStudio Server Professional Administration
Guide appendix for a list of command IDs.

Note that there is a small performance penalty incurred across the IDE when
a command stream listener is present. If you only need to listen to a few
specific commands, it is recommended to set up callbacks for them individually
using \code{\link{registerCommandCallback}}.
}
\note{
The \code{registerCommandStreamCallback} function was introduced in RStudio 1.4.1589.
}
\examples{

\dontrun{
# Set up a callback to print the ID of commands executed to the console.
handle <- rstudioapi::registerCommandStreamCallback(function(id) {
  message("Command executed: ", id)
})

# Later: Unregister the callback
rstudioapi::unregisterCommandCallback(handle)
}
}
\seealso{
\code{\link{unregisterCommandCallback}} to unregister the callback, and
\code{\link{registerCommandCallback}} to be notified whenever a \emph{specific} command
is executed.
}
