% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{LogNormalize}
\alias{LogNormalize}
\title{Normalize raw data}
\usage{
LogNormalize(data, scale.factor = 10000, verbose = TRUE)
}
\arguments{
\item{data}{Matrix with the raw count data}

\item{scale.factor}{Scale the data. Default is 1e4}

\item{verbose}{Print progress}
}
\value{
Returns a matrix with the normalize and log transformed data
}
\description{
Normalize count data per cell and transform to log scale
}
\examples{
mat <- matrix(data = rbinom(n = 25, size = 5, prob = 0.2), nrow = 5)
mat
mat_norm <- LogNormalize(data = mat)
mat_norm

}
\concept{preprocessing}
