% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{runExample}
\alias{runExample}
\title{Run Shiny Example Applications}
\usage{
runExample(
  example = NA,
  port = NULL,
  launch.browser = getOption("shiny.launch.browser", interactive()),
  host = getOption("shiny.host", "127.0.0.1"),
  display.mode = c("auto", "normal", "showcase")
)
}
\arguments{
\item{example}{The name of the example to run, or \code{NA} (the default) to
list the available examples.}

\item{port}{The TCP port that the application should listen on. Defaults to
choosing a random port.}

\item{launch.browser}{If true, the system's default web browser will be
launched automatically after the app is started. Defaults to true in
interactive sessions only.}

\item{host}{The IPv4 address that the application should listen on. Defaults
to the \code{shiny.host} option, if set, or \code{"127.0.0.1"} if not.}

\item{display.mode}{The mode in which to display the example. Defaults to
\code{showcase}, but may be set to \code{normal} to see the example without
code or commentary.}
}
\description{
Launch Shiny example applications, and optionally, your system's web browser.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  # List all available examples
  runExample()

  # Run one of the examples
  runExample("01_hello")

  # Print the directory containing the code for all examples
  system.file("examples", package="shiny")
}
}
