% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_labels.R, R/remove_labels.R
\name{add_labels}
\alias{add_labels}
\alias{replace_labels}
\alias{remove_labels}
\title{Add, replace or remove value labels of variables}
\usage{
add_labels(x, ..., labels)

replace_labels(x, ..., labels)

remove_labels(x, ..., labels)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's select-helpers.
See 'Examples'.}

\item{labels}{\describe{
\item{For \code{add_labels()}}{A named (numeric) vector of labels
that will be added to \code{x} as label attribute.}
\item{For \code{remove_labels()}}{Either a numeric vector, indicating
the position of one or more label attributes that should be removed;
a character vector with names of label attributes that should be
removed; or a \code{\link[haven:tagged_na]{tagged_na()}} to remove the labels
from specific NA values.}
}}
}
\value{
\code{x} with additional or removed value labels. If \code{x}
          is a data frame, the complete data frame \code{x} will be returned,
          with removed or added to variables specified in \code{...};
          if \code{...} is not specified, applies to all variables in the
          data frame.
}
\description{
These functions add, replace or remove value labels to or from variables.
}
\details{
\code{add_labels()} adds \code{labels} to the existing value
         labels of \code{x}, however, unlike \code{\link{set_labels}}, it
         does \emph{not} remove labels that were \emph{not} specified in
         \code{labels}. \code{add_labels()} also replaces existing
         value labels, but preserves the remaining labels.
         \cr \cr
         \code{remove_labels()} is the counterpart to \code{add_labels()}.
         It removes labels from a label attribute of \code{x}.
         \cr \cr
         \code{replace_labels()} is an alias for \code{add_labels()}.
}
\examples{
# add_labels()
data(efc)
get_labels(efc$e42dep)

x <- add_labels(efc$e42dep, labels = c(`nothing` = 5))
get_labels(x)

if (require("dplyr")) {
  x <- efc \%>\%
    # select three variables
    dplyr::select(e42dep, c172code, c161sex) \%>\%
    # only add new label to two of those
    add_labels(e42dep, c172code, labels = c(`nothing` = 5))
  # see data frame, with selected variables having new labels
  get_labels(x)
}

x <- add_labels(efc$e42dep, labels = c(`nothing` = 5, `zero value` = 0))
get_labels(x, values = "p")

# replace old value labels
x <- add_labels(
  efc$e42dep,
  labels = c(`not so dependent` = 4, `lorem ipsum` = 5)
)
get_labels(x, values = "p")

# replace specific missing value (tagged NA)
if (require("haven")) {
  x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1),
                c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                  "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
  # get current NA values
  x
  # tagged NA(c) has currently the value label "First", will be
  # replaced by "Second" now.
  replace_labels(x, labels = c("Second" = tagged_na("c")))
}


# remove_labels()

x <- remove_labels(efc$e42dep, labels = 2)
get_labels(x, values = "p")

x <- remove_labels(efc$e42dep, labels = "independent")
get_labels(x, values = "p")

if (require("haven")) {
  x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1),
                c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                  "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
  # get current NA values
  get_na(x)
  get_na(remove_labels(x, labels = tagged_na("c")))
}
}
\seealso{
\code{\link{set_label}} to manually set variable labels or
           \code{\link{get_label}} to get variable labels; \code{\link{set_labels}} to
           add value labels, replacing the existing ones (and removing non-specified
           value labels).
}
