% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_long.R
\name{to_long}
\alias{to_long}
\title{Convert wide data to long format}
\usage{
to_long(data, keys, values, ..., labels = NULL, recode.key = FALSE)
}
\arguments{
\item{data}{A \code{data.frame} that should be tansformed from wide to
long format.}

\item{keys}{Character vector with name(s) of key column(s) to create in output.
Either one key value per column group that should be gathered, or
a single string. In the latter case, this name will be used as
key column, and only one key column is created. See 'Examples'.}

\item{values}{Character vector with names of value columns (variable names)
to create in output. Must be of same length as number of column
groups that should be gathered. See 'Examples'.}

\item{...}{Specification of columns that should be gathered. Must be one
character vector with variable names per column group, or a numeric
vector with column indices indicating those columns that should be
gathered. See 'Examples'.}

\item{labels}{Character vector of same length as \code{values} with variable
labels for the new variables created from gathered columns.
See 'Examples' and 'Details'.}

\item{recode.key}{Logical, if \code{TRUE}, the values of the \code{key}
column will be recoded to numeric values, in sequential ascending
order.}
}
\description{
This function converts wide data into long format. It allows
               to transform multiple key-value pairs to be transformed
               from wide to long format in one single step.
}
\details{
This function reshapes data from wide to long format, however,
  you can gather multiple column groups at once. Value and variable labels
  for non-gathered variables are preserved. Attributes from gathered variables,
  such as information about the variable labels, are lost during reshaping.
  Hence, the new created variables from gathered columns don't have any
  variable label attributes. In such cases, use \code{labels} argument to set
  back variable label attributes.
}
\examples{
# create sample
mydat <- data.frame(age = c(20, 30, 40),
                    sex = c("Female", "Male", "Male"),
                    score_t1 = c(30, 35, 32),
                    score_t2 = c(33, 34, 37),
                    score_t3 = c(36, 35, 38),
                    speed_t1 = c(2, 3, 1),
                    speed_t2 = c(3, 4, 5),
                    speed_t3 = c(1, 8, 6))

# gather multiple columns. both time and speed are gathered.
to_long(
  data = mydat,
  keys = "time",
  values = c("score", "speed"),
  c("score_t1", "score_t2", "score_t3"),
  c("speed_t1", "speed_t2", "speed_t3")
)

# alternative syntax, using "reshape_longer()"
reshape_longer(
  mydat,
  columns = list(
    c("score_t1", "score_t2", "score_t3"),
    c("speed_t1", "speed_t2", "speed_t3")
  ),
  names.to = "time",
  values.to = c("score", "speed")
)

# or ...
reshape_longer(
  mydat,
  list(3:5, 6:8),
  names.to = "time",
  values.to = c("score", "speed")
)

# gather multiple columns, use numeric key-value
to_long(
  data = mydat,
  keys = "time",
  values = c("score", "speed"),
  c("score_t1", "score_t2", "score_t3"),
  c("speed_t1", "speed_t2", "speed_t3"),
  recode.key = TRUE
)

# gather multiple columns by colum names and colum indices
to_long(
  data = mydat,
  keys = "time",
  values = c("score", "speed"),
  c("score_t1", "score_t2", "score_t3"),
  6:8,
  recode.key = TRUE
)

# gather multiple columns, use separate key-columns
# for each value-vector
to_long(
  data = mydat,
  keys = c("time_score", "time_speed"),
  values = c("score", "speed"),
  c("score_t1", "score_t2", "score_t3"),
  c("speed_t1", "speed_t2", "speed_t3")
)

# gather multiple columns, label columns
mydat <- to_long(
  data = mydat,
  keys = "time",
  values = c("score", "speed"),
  c("score_t1", "score_t2", "score_t3"),
  c("speed_t1", "speed_t2", "speed_t3"),
  labels = c("Test Score", "Time needed to finish")
)

library(sjlabelled)
str(mydat$score)
get_label(mydat$speed)

}
\seealso{
\code{\link{reshape_longer}}
}
