% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotFA.R
\name{sjp.fa}
\alias{sjp.fa}
\title{Plot FA results}
\usage{
sjp.fa(
  data,
  rotation = c("promax", "varimax"),
  method = c("ml", "minres", "wls", "gls", "pa", "minchi", "minrank"),
  nmbr.fctr = NULL,
  fctr.load.tlrn = 0.1,
  digits = 2,
  title = NULL,
  axis.labels = NULL,
  type = c("bar", "circle", "tile"),
  geom.size = 0.6,
  geom.colors = "RdBu",
  wrap.title = 50,
  wrap.labels = 30,
  show.values = TRUE,
  show.cronb = TRUE
)
}
\arguments{
\item{data}{A data frame that should be used to compute a FA, or a \code{\link[psych]{fa}} object.}

\item{rotation}{Rotation of the factor loadings. May be \code{"varimax"} for orthogonal rotation
or \code{"promax"} for oblique transformation (default). Requires the \code{"GPArotation"} package.}

\item{method}{the factoring method to be used. \code{"ml"} will do a maximum likelihood factor analysis (default).
\code{"minres"} will do a minimum residual (OLS),
\code{"wls"} will do a weighted least squares (WLS) solution,
\code{"gls"} does a generalized weighted least squares (GLS),
\code{"pa"} will do the principal factor solution,
\code{"minchi"} will minimize the sample size weighted chi square
when treating pairwise correlations with different number of
subjects per pair. \code{"minrank"} will do a minimum rank factor analysis.}

\item{nmbr.fctr}{Number of factors used for calculating the rotation. By
default, this value is \code{NULL} and the amount of factors is
calculated according to a parallel analysis.}

\item{fctr.load.tlrn}{Specifies the minimum difference a variable needs to have between
factor loadings (components) in order to indicate a clear loading on just one factor and not
diffusing over all factors. For instance, a variable with 0.8, 0.82 and 0.84 factor loading
on 3 possible factors can not be clearly assigned to just one factor and thus would be removed
from the principal component analysis. By default, the minimum difference of loading values
between the highest and 2nd highest factor should be 0.1}

\item{digits}{Amount of decimals for estimates}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.
For effect-plots, may also be a character vector of length > 1,
to define titles for each sub-plot or facet.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{type}{Plot type resp. geom type. May be one of following: \code{"circle"} or \code{"tile"}
circular or tiled geoms, or \code{"bar"} for a bar plot. You may use initial letter only
for this argument.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size,
depending on plot type and function). Note that bar and bin widths mostly
need smaller values than dot sizes.}

\item{geom.colors}{user defined color for geoms. See 'Details' in \code{\link{plot_grpfrq}}.}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis
labels are displayed in one line and when a line break is inserted.}

\item{show.values}{Logical, whether values should be plotted or not.}

\item{show.cronb}{Logical, if \code{TRUE} (default), the cronbach's alpha value for each factor scale will be calculated,
i.e. all variables with the highest loading for a factor are taken for the
reliability test. The result is an alpha value for each factor dimension.
Only applies when \code{data} is a data frame.}
}
\value{
(Invisibly) returns a \code{\link{structure}} with
         \itemize{
           \item the rotated factor loading matrix (\code{rotate})
           \item the column indices of removed variables (for more details see next list item) (\code{removed.colindex})
           \item an updated data frame containing all factors that have a clear loading on a specific scale in case \code{data} was a data frame (See argument \code{fctr.load.tlrn} for more details) (\code{removed.df})
           \item the \code{factor.index}, i.e. the column index of each variable with the highest factor loading for each factor,
           \item the ggplot-object (\code{plot}),
           \item the data frame that was used for setting up the ggplot-object (\code{df}).
           }
}
\description{
Performes a maximum likelihood factor analysis on a data frame or matrix
               and plots the factor solution as ellipses or tiles. \cr
               In case a data frame is used as argument, the cronbach's alpha value for
               each factor scale will be calculated, i.e. all variables with the highest
               loading for a factor are taken for the reliability test. The result is
               an alpha value for each factor dimension.
}
\note{
This method for factor analysis relies on the functions
      \code{\link[psych]{fa}} and \code{\link[psych]{fa.parallel}}
      from the psych package.
}
\examples{
library(GPArotation)
data(efc)
# recveive first item of COPE-index scale
start <- which(colnames(efc) == "c82cop1")
# recveive last item of COPE-index scale
end <- which(colnames(efc) == "c90cop9")

# use data frame as argument, let sjp.fa() compute FA
sjp.fa(efc[, start:end])
sjp.fa(efc[, start:end], type = "tile")

}
