% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{split.array}
\alias{split.array}
\alias{split.matrix}
\title{A \code{\link[=split]{split()}} method for \code{\link{array}} and \code{\link{matrix}} types on a margin.}
\usage{
\method{split}{array}(x, f, drop = FALSE, margin = NULL, ...)

\method{split}{matrix}(x, f, drop = FALSE, margin = NULL, ...)
}
\arguments{
\item{x}{A \code{\link{matrix}} or an \code{\link{array}}.}

\item{f, drop}{See help for \code{\link[=split]{split()}}. Note that \code{drop} here is
\emph{not} for array dimensions: these are always preserved.}

\item{margin}{Which margin of the array to split along. \code{NULL}
splits as \code{\link{split.default}}, dropping dimensions.}

\item{...}{Additional arguments to \code{\link[=split]{split()}}.}
}
\description{
These methods split an \code{\link{array}} and \code{\link{matrix}} into a list of
arrays or matrices with the same number of dimensions
according to the specified margin.
}
\examples{

x <- diag(5)
f <- rep(1:2, c(2,3))
split(x, f, margin=1) # Split rows.
split(x, f, margin=2) # Split columns.

# This is similar to how data frames are split:
stopifnot(identical(split(x, f, margin=1),
          lapply(lapply(split(as.data.frame(x), f), as.matrix), unname)))

}
