% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_detect_4.R
\name{stri_detect}
\alias{stri_detect}
\alias{stri_detect_fixed}
\alias{stri_detect_charclass}
\alias{stri_detect_coll}
\alias{stri_detect_regex}
\title{Detect Pattern Occurrences}
\usage{
stri_detect(str, ..., regex, fixed, coll, charclass)

stri_detect_fixed(
  str,
  pattern,
  negate = FALSE,
  max_count = -1,
  ...,
  opts_fixed = NULL
)

stri_detect_charclass(str, pattern, negate = FALSE, max_count = -1)

stri_detect_coll(
  str,
  pattern,
  negate = FALSE,
  max_count = -1,
  ...,
  opts_collator = NULL
)

stri_detect_regex(
  str,
  pattern,
  negate = FALSE,
  max_count = -1,
  ...,
  opts_regex = NULL
)
}
\arguments{
\item{str}{character vector; strings to search in}

\item{...}{supplementary arguments passed to the underlying functions,
including additional settings for \code{opts_collator}, \code{opts_regex},
\code{opts_fixed}, and so on}

\item{pattern, regex, fixed, coll, charclass}{character vector;
search patterns; for more details refer to \link{stringi-search}}

\item{negate}{single logical value; whether a no-match to a pattern
is rather of interest}

\item{max_count}{single integer; allows to stop searching once a given
number of occurrences is detected; \code{-1} (the default) inspects all
elements}

\item{opts_collator, opts_fixed, opts_regex}{a named list used to tune up
the search engine's settings; see
\code{\link{stri_opts_collator}}, \code{\link{stri_opts_fixed}},
and \code{\link{stri_opts_regex}}, respectively; \code{NULL}
for the defaults}
}
\value{
Each function returns a logical vector.
}
\description{
These functions determine, for each string in \code{str},
if there is at least one match to a corresponding \code{pattern}.
}
\details{
Vectorized over \code{str} and \code{pattern} (with recycling
of the elements in the shorter vector if necessary). This allows to,
for instance, search for one pattern in each given string,
search for each pattern in one given string,
and search for the i-th pattern within the i-th string.

If \code{pattern} is empty, then the result is \code{NA}
and a warning is generated.

\code{stri_detect} is a convenience function.
It calls either \code{stri_detect_regex},
\code{stri_detect_fixed}, \code{stri_detect_coll},
or \code{stri_detect_charclass}, depending on the argument used.

See also \code{\link{stri_startswith}} and \code{\link{stri_endswith}}
for testing whether a string starts or ends with a match to a given pattern.
Moreover, see \code{\link{stri_subset}} for a character vector subsetting.

If \code{max_count} is negative, then all stings are examined.
Otherwise, searching terminates
once \code{max_count} matches (or, if \code{negate} is \code{TRUE},
no-matches) are detected. The uninspected cases are marked
as missing in the return vector. Be aware that, unless \code{pattern} is a
singleton, the elements in \code{str} might be inspected in a
non-consecutive order.
}
\examples{
stri_detect_fixed(c('stringi R', 'R STRINGI', '123'), c('i', 'R', '0'))
stri_detect_fixed(c('stringi R', 'R STRINGI', '123'), 'R')

stri_detect_charclass(c('stRRRingi','R STRINGI', '123'),
   c('\\\\p{Ll}', '\\\\p{Lu}', '\\\\p{Zs}'))

stri_detect_regex(c('stringi R', 'R STRINGI', '123'), 'R.')
stri_detect_regex(c('stringi R', 'R STRINGI', '123'), '[[:alpha:]]*?')
stri_detect_regex(c('stringi R', 'R STRINGI', '123'), '[a-zC1]')
stri_detect_regex(c('stringi R', 'R STRINGI', '123'), '( R|RE)')
stri_detect_regex('stringi', 'STRING.', case_insensitive=TRUE)

stri_detect_regex(c('abc', 'def', '123', 'ghi', '456', '789', 'jkl'),
   '^[0-9]+$', max_count=1)
stri_detect_regex(c('abc', 'def', '123', 'ghi', '456', '789', 'jkl'),
   '^[0-9]+$', max_count=2)
stri_detect_regex(c('abc', 'def', '123', 'ghi', '456', '789', 'jkl'),
   '^[0-9]+$', negate=TRUE, max_count=3)

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other search_detect: 
\code{\link{about_search}},
\code{\link{stri_startswith}()}
}
\concept{search_detect}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
