% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tk2dde.R
\name{tk2dde}
\alias{tk2dde}
\alias{tk2dde.exec}
\alias{tk2dde.poke}
\alias{tk2dde.request}
\alias{tk2dde.services}
\title{Use DDE (Dynamic Data Exchange) under Windows}
\usage{
tk2dde(topic = NULL)

tk2dde.exec(service, topic, command, async = FALSE)

tk2dde.poke(service, topic, item, data)

tk2dde.request(service, topic, item, binary = FALSE)

tk2dde.services(service = "", topic = "")
}
\arguments{
\item{topic}{The 'topic' to reach or expose. A DDE server is accessed as
service'|'topic'. In the case of \code{\link[=tk2dde]{tk2dde()}}, a non null topic activates
the DDE server, and a null topic deactivate it.}

\item{service}{The name of the service to reach. In \code{tk2dde.services}, if
both service and topic are empty, the list of all available DDE service is
returned, otherwise, only available topics for a given service are listed.}

\item{command}{A string with the command to run in the external application
(syntax depends on the server).}

\item{async}{Is a command run asynchroneously (returns immediately, before
the command is processed), or not?}

\item{item}{The concerned item (usually a variable name, a range in a
worksheet, etc...).}

\item{data}{The new value for the item.}

\item{binary}{Should the return be treated as binary data or not?}
}
\description{
DDE is the first Microsoft's attempt to make an inter-application mechanism.
It is now superseeded by (D)Com, but it is still available (although declared
as unsupported). Being simpler than Com, DDE is interesting for simple tasks.
Applications like Word or Excel provide services one can access through DDE
(see examples). This code if left for backward compatibility, and also, just
in case you will find some use of it. But for new projects in general, you
should not use this any more.
}
\note{
This is only available under Windows. Trying to use these functions under
other platforms raises an error. Under Windows, R is automatically configured
as a DDE server with name 'TclEval|SciViewsR' when this package is loaded.
}
\examples{
\dontrun{
# These cannot be run by examples() but should be OK when pasted
# into an interactive R session with the tcltk package loaded

# Examples of DDE - Windows only

### Examples using wish ###
# Start a Wish84 console side-by-side with R.
# (to get wish, you need to install ActiveTcl from
# http://www.activestate.com/Products/ActiveTcl/)
# Once it is done, start 'Wish84' from the start menu)
# Register the Wish console as a DDE server, that is, type in it
# (\% is the Tcl prompt, do not type it!):
# \% package require dde
# \% dde servername wish

### In R:
tk2dde("R") # Return 0 if succeed
tk2dde.services()
# Evaluate some string in wish
tk2dde.exec("TclEval", "wish", "{puts {Hello World!}}")
# Give a value to a variable in wish
tk2dde.poke("TclEval", "wish", "myvar", "{This is a string!}")
# Note that you must surround strings with curly braces in Tcl!
tk2dde.poke("TclEval", "wish", "mynumvar", c(34.56, 78.9))

# In wish, check that vars exist and have correct value
# \% puts $myvar
# \% puts $mynumvar

# Get the value of one variable from wish into R
tk2dde.request("TclEval", "wish", "myvar")
tk2dde.request("TclEval", "wish", "mynumvar")
# Note that you do not know here if it is a string, a number, or so...
# You have to know and convert yourself!

# Now, the other way: execute a R function from wish
# You first need to register a R function for callback
# (For the moment, only functions without arguments are supported!)
doDDE <- function() cat("DDE execute!")	# A simple function
tclFun(doDDE)
# And in wish
# \% dde execute TclEval R doDDE

# Once you have defined a variable using tclVar, you can get or change it
# from the dde server. However, tclVar gives cryptic names like ::RTcl1.
# So we prefer to use tclVarName()
myvar2 <- tclVarName("myvar2", "this is a test...")
tclvalue(myvar2) # This is the way we access to this variable in R

# In wish you get the value and change it:
# \% dde request TclEval R myvar2
# Again, dde poke does not work and must be replaced by an execute command
# This does not work (???)
# \% dde poke TclEval R myvar2 {yes! and it works...}
# ... but this is fine
# \% dde execute TclEval R {set myvar2 {yes! and it works...}}

# And in R...
tclvalue(myvar2)

### DDE at the command line with execdde.exe ###
# You can also change the value of a variable, or run a command in R from
# the command line using execdde.exe:
# - Download execdde.exe from http://www.sciviews.org/SciViews-R/execdde.zip
# - Unzip it and copy 'execdde.exe' somewhere in your path,
# - Start a DOS window
# - Enter the following commands ('>' is the prompt, do not type it):
# > execdde -s TclEval -t R -c doDDE > NUL
# > if errorlevel 1 echo An error occurs... branch accordingly in your batch!
# > execdde -s TclEval -t R -c "set myvar2 'ok from execdde'" > NUL

# And in R:
tclvalue(myvar2)
# Note: thanks to separate event loops, it works also when R calculates...

### Manipulating Microsoft Excel ###
# Start Excel with a blank workbook, then...

# Change values in Excel from R:
tk2dde.poke("Excel", "Sheet1", "R1C1:R2C1", c("5.7", "6.34"))   # Some data
tk2dde.poke("Excel", "Sheet1", "R3C1", "= A1 + A2")             # A formula

# Read values in Excel (note that results of formulas are returned)
Res <- tk2dde.request("Excel", "Sheet1", "R1C1:R3C1")
Res
as.numeric(Res)

}
}
\seealso{
\code{\link[=tk2reg.get]{tk2reg.get()}}
}
\author{
Philippe Grosjean
}
\keyword{utilities}
