% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tk2tip.R
\name{tk2tip}
\alias{tk2tip}
\alias{tk2killtip}
\alias{tip}
\alias{tip.tk2widget}
\alias{tip<-}
\alias{tip<-.tk2widget}
\title{Display and manage tooltips in Tk widgets}
\usage{
tk2tip(widget, message)

tk2killtip()

tip(x, ...)

\method{tip}{tk2widget}(x, ...)

tip(x) <- value

\method{tip}{tk2widget}(x) <- value
}
\arguments{
\item{widget}{The widget to which a tooltip is attached.}

\item{message}{The message of the tooltip (\code{""} to remove the tooltip).}

\item{x}{A tk2widget object.}

\item{...}{Further arguments to the method (unused, but reserved for
future use).}

\item{value}{The message of the tooltip, or \code{""} to remove the tip.}
}
\value{
The current tip or \code{NULL} depending on the function.
}
\description{
\code{\link[=tk2tip]{tk2tip()}} provides a simple mechanism to display tooltips on Tk widgets when
the mouse cursor hoovers on top of them.
}
\note{
This implementation is done in pure Tcl code.
}
\examples{
\dontrun{
# These cannot be run by examples() but should be OK when pasted
# into an interactive R session with the tcltk package loaded

# Using plain Tcl/Tk label and button (tk2XXX equivalent have built-in
# tooltip features)
tt <- tktoplevel()
lb <- tklabel(tt, text = "Move mouse over me, or over the button to see tooltip")
tkgrid(lb)
tk2tip(lb, "A tooltip for the label \ndisplayed on two lines")
but <- tkbutton(tt, text = "Exit", width = 10,
  command = function() tkdestroy(tt))
tkgrid(but)
tk2tip(but, "Exit from this dialog box")

# To test tk2killtip(), move mouse on top of a widget
# so that the tip is visible, and force killing it manually using:
tk2killtip()
# Move again to the widget: the tip is displayed again.

# With tk2widgets, the tip() method can also be used:
lb2 <- tk2label(tt, text = "Move also over me to see the tooltip")
tkgrid(lb2)
tip(lb2) # No tip yet
tip(lb2) <- "Now the tooltip is there!"
# Move the mouse over that last label

tip(lb2) # Yes, this is my tooltip
tip(lb2) <- NULL # To eliminate the tooltip for this widget
}
}
\seealso{
\code{\link[=tk2button]{tk2button()}}, \code{\link[=label]{label()}}
}
\author{
Philippe Grosjean
}
\keyword{utilities}
