% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makevars.R
\name{set_makevars}
\alias{set_makevars}
\title{Create a new \code{Makevars} file, by adding new variables}
\usage{
set_makevars(variables, old_path = file.path("~", ".R", "Makevars"),
  new_path = tempfile(), assignment = c("=", ":=", "?=", "+="))
}
\arguments{
\item{variables}{\code{[named character]}\cr new variables and their values}

\item{old_path}{\code{[character(1)]}\cr location of existing \code{Makevars}
file to modify.}

\item{new_path}{\code{[character(1)]}\cr location of the new \code{Makevars} file}

\item{assignment}{\code{[character(1)]}\cr assignment type to use.}
}
\description{
You probably want \code{\link[=with_makevars]{with_makevars()}} instead of this function.
}
\details{
Unlike \code{\link[=with_makevars]{with_makevars()}}, it does not activate the new \code{Makevars}
file, i.e. it does not set the \code{R_MAKEVARS_USER} environment variable.
}
\keyword{internal}
