% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_modify.R
\name{xml_replace}
\alias{xml_replace}
\alias{xml_add_sibling}
\alias{xml_add_child}
\alias{xml_add_parent}
\alias{xml_remove}
\title{Modify a tree by inserting, replacing or removing nodes}
\usage{
xml_replace(.x, .value, ..., .copy = TRUE)

xml_add_sibling(.x, .value, ..., .where = c("after", "before"),
  .copy = TRUE)

xml_add_child(.x, .value, ..., .where = length(xml_children(.x)),
  .copy = TRUE)

xml_add_parent(.x, .value, ...)

xml_remove(.x, free = FALSE)
}
\arguments{
\item{.x}{a document, node or nodeset.}

\item{.value}{node to insert.}

\item{...}{If named attributes or namespaces to set on the node, if unnamed
text to assign to the node.}

\item{.copy}{whether to copy the \code{.value} before replacing. If this is \code{FALSE}
then the node will be moved from it's current location.}

\item{.where}{to add the new node, for \code{xml_add_child} the position
after which to add, use \code{0} for the first child. For
\code{xml_add_sibling} either \sQuote{"before"} or \sQuote{"after"}
indicating if the new node should be before or after \code{.x}.}

\item{free}{When removing the node also free the memory used for that node.
Note if you use this option you cannot use any existing objects pointing to
the node or its children, it is likely to crash R or return garbage.}
}
\description{
\code{xml_add_sibling()} and \code{xml_add_child()} are used to insert a node
as a sibling or a child. \code{xml_add_parent()} adds a new parent in
between the input node and the current parent. \code{xml_replace()}
replaces an existing node with a new node. \code{xml_remove()} removes a
node from the tree.
}
\details{
Care needs to be taken when using \code{xml_remove()},
}
