% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_attr.R
\name{xml_attr}
\alias{xml_attr}
\alias{xml_has_attr}
\alias{xml_attrs}
\alias{xml_attr<-}
\alias{xml_set_attr}
\alias{xml_attrs<-}
\alias{xml_set_attrs}
\title{Retrieve an attribute.}
\usage{
xml_attr(x, attr, ns = character(), default = NA_character_)

xml_has_attr(x, attr, ns = character())

xml_attrs(x, ns = character())

xml_attr(x, attr, ns = character()) <- value

xml_set_attr(x, attr, value, ns = character())

xml_attrs(x, ns = character()) <- value

xml_set_attrs(x, value, ns = character())
}
\arguments{
\item{x}{A document, node, or node set.}

\item{attr}{Name of attribute to extract.}

\item{ns}{Optionally, a named vector giving prefix-url pairs, as produced
by \code{\link[=xml_ns]{xml_ns()}}. If provided, all names will be explicitly
qualified with the ns prefix, i.e. if the element \code{bar} is defined
in namespace \code{foo}, it will be called \code{foo:bar}. (And
similarly for attributes). Default namespaces must be given an explicit
name. The ns is ignored when using \code{\link[=xml_name<-]{xml_name<-()}} and
\code{\link[=xml_set_name]{xml_set_name()}}.}

\item{default}{Default value to use when attribute is not present.}

\item{value}{character vector of new value.}
}
\value{
\code{xml_attr()} returns a character vector. \code{NA} is used
to represent of attributes that aren't defined.

\code{xml_has_attr()} returns a logical vector.

\code{xml_attrs()} returns a named character vector if \code{x} x is single
node, or a list of character vectors if given a nodeset
}
\description{
\code{xml_attrs()} retrieves all attributes values as a named character
vector, \verb{xml_attrs() <-} or \code{xml_set_attrs()} sets all attribute
values. \code{xml_attr()} retrieves the value of single attribute and
\verb{xml_attr() <-} or \code{xml_set_attr()} modifies its value. If the
attribute doesn't exist, it will return \code{default}, which defaults to
\code{NA}. \code{xml_has_attr()} tests if an attribute is present.
}
\examples{
x <- read_xml("<root id='1'><child id ='a' /><child id='b' d='b'/></root>")
xml_attr(x, "id")
xml_attr(x, "apple")
xml_attrs(x)

kids <- xml_children(x)
kids
xml_attr(kids, "id")
xml_has_attr(kids, "id")
xml_attrs(kids)

# Missing attributes give missing values
xml_attr(xml_children(x), "d")
xml_has_attr(xml_children(x), "d")

# If the document has a namespace, use the ns argument and
# qualified attribute names
x <- read_xml('
 <root xmlns:b="http://bar.com" xmlns:f="http://foo.com">
   <doc b:id="b" f:id="f" id="" />
 </root>
')
doc <- xml_children(x)[[1]]
ns <- xml_ns(x)

xml_attrs(doc)
xml_attrs(doc, ns)

# If you don't supply a ns spec, you get the first matching attribute
xml_attr(doc, "id")
xml_attr(doc, "b:id", ns)
xml_attr(doc, "id", ns)

# Can set a single attribute with `xml_attr() <-` or `xml_set_attr()`
xml_attr(doc, "id") <- "one"
xml_set_attr(doc, "id", "two")

# Or set multiple attributes with `xml_attrs()` or `xml_set_attrs()`
xml_attrs(doc) <- c("b:id" = "one", "f:id" = "two", "id" = "three")
xml_set_attrs(doc, c("b:id" = "one", "f:id" = "two", "id" = "three"))
}
