% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variant2disease.R
\name{variant2disease}
\alias{variant2disease}
\title{Retrieves diseases associated to a variant or list of variants and generates an \code{DataGeNET.DGN}}
\usage{
variant2disease(
  variant,
  database = "CURATED",
  score = c(0, 1),
  api_key = NULL,
  verbose = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{variant}{a variant, or list of variants}

\item{database}{Name of the database that will be queried. It can take the values:
\code{'UNIPROT'} to use Universal Protein Resource;
\code{'CLINVAR'} to use ClinVar, a public archive of relationships
among sequence variation and human phenotype;
\code{'GWASCAT'} to use the NHGRI-EBI GWAS Catalog;
\code{'GWASDB'} to use the GWAS Database GWASdb;
\code{'CURATED'} to use expert curated, human databases;
\code{'ALL'} to use all these databases. Default \code{'CURATED'}.
\code{'BEFREE'} to use text mining data, generated using BeFree System;}

\item{score}{A vector with two elements: 1) initial value of score 2) final value of score}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get a
on-time log from the function.}

\item{warnings}{By default \code{TRUE}. Change it to \code{FALSE} to not see
the warnings.}
}
\value{
An object of class \code{DataGeNET.DGN}
}
\description{
Given a variant or a list of variants, it retrieves the variant-disease associations
related to diseases in DisGeNET. It creates an object of type \code{DataGeNET.DGN}.
}
\examples{
vd <- variant2disease(variant = "rs121909211", database = "CURATED",  verbose = FALSE, warnings = TRUE)
}
