
;; This table omits anything that the expander implements itself,
;; since the expander will export its own variant instead of the
;; `kernel-table` variant.

(define-primitive-table kernel-table
  [* (known-procedure -1)]
  [+ (known-procedure -1)]
  [- (known-procedure -2)]
  [/ (known-procedure -2)]
  [< (known-procedure -2)]
  [<= (known-procedure -2)]
  [= (known-procedure -2)]
  [> (known-procedure -2)]
  [>= (known-procedure -2)]
  [abort-current-continuation (known-procedure -2)]
  [abs (known-procedure 2)]
  [absolute-path? (known-procedure 2)]
  [acos (known-procedure 2)]
  [add1 (known-procedure 2)]
  [alarm-evt (known-procedure 2)]
  [always-evt (known-constant)]
  [andmap (known-procedure -4)]
  [angle (known-procedure 2)]
  [append (known-procedure -1)]
  [apply (known-procedure -4)]
  [arithmetic-shift (known-procedure 4)]
  [arity-at-least (known-constant)]
  [arity-at-least-value (known-procedure 2)]
  [arity-at-least? (known-procedure/pure 2)]
  [asin (known-procedure 2)]
  [assoc (known-procedure 4)]
  [assq (known-procedure 4)]
  [assv (known-procedure 4)]
  [atan (known-procedure 6)]
  [banner (known-procedure/pure 1)]
  [bitwise-and (known-procedure -1)]
  [bitwise-bit-field (known-procedure 8)]
  [bitwise-bit-set? (known-procedure 4)]
  [bitwise-ior (known-procedure -1)]
  [bitwise-not (known-procedure 2)]
  [bitwise-xor (known-procedure -1)]
  [boolean? (known-procedure/pure 2)]
  [box (known-procedure/pure 2)]
  [box-cas! (known-procedure 8)]
  [box-immutable (known-procedure/pure 2)]
  [box? (known-procedure/pure 2)]
  [break-enabled (known-procedure 3)]
  [break-thread (known-procedure 6)]
  [build-path (known-procedure -2)]
  [build-path/convention-type (known-procedure -4)]
  [byte-pregexp (known-procedure 6)]
  [byte-pregexp? (known-procedure/pure 2)]
  [byte-ready? (known-procedure 3)]
  [byte-regexp (known-procedure 6)]
  [byte-regexp? (known-procedure/pure 2)]
  [byte? (known-procedure/pure 2)]
  [bytes (known-procedure -1)]
  [bytes->immutable-bytes (known-procedure 2)]
  [bytes->list (known-procedure 2)]
  [bytes->path (known-procedure 6)]
  [bytes->path-element (known-procedure 6)]
  [bytes->string/latin-1 (known-procedure 30)]
  [bytes->string/locale (known-procedure 30)]
  [bytes->string/utf-8 (known-procedure 30)]
  [bytes-append (known-procedure -1)]
  [bytes-close-converter (known-procedure 2)]
  [bytes-convert (known-procedure 254)]
  [bytes-convert-end (known-procedure 15)]
  [bytes-converter? (known-procedure/pure 2)]
  [bytes-copy (known-procedure 2)]
  [bytes-copy! (known-procedure 56)]
  [bytes-fill! (known-procedure 4)]
  [bytes-length (known-procedure 2)]
  [bytes-open-converter (known-procedure 4)]
  [bytes-ref (known-procedure 4)]
  [bytes-set! (known-procedure 8)]
  [bytes-utf-8-index (known-procedure 28)]
  [bytes-utf-8-length (known-procedure 30)]
  [bytes-utf-8-ref (known-procedure 28)]
  [bytes<? (known-procedure -2)]
  [bytes=? (known-procedure -2)]
  [bytes>? (known-procedure -2)]
  [bytes? (known-procedure/pure 2)]
  [caaaar (known-procedure 2)]
  [caaadr (known-procedure 2)]
  [caaar (known-procedure 2)]
  [caadar (known-procedure 2)]
  [caaddr (known-procedure 2)]
  [caadr (known-procedure 2)]
  [caar (known-procedure 2)]
  [cadaar (known-procedure 2)]
  [cadadr (known-procedure 2)]
  [cadar (known-procedure 2)]
  [caddar (known-procedure 2)]
  [cadddr (known-procedure 2)]
  [caddr (known-procedure 2)]
  [cadr (known-procedure 2)]
  [call-in-nested-thread (known-procedure 6)]
  [call-with-composable-continuation (known-procedure 6)]
  [call-with-continuation-barrier (known-procedure 2)]
  [call-with-continuation-prompt (known-procedure -2)]
  [call-with-current-continuation (known-procedure 6)]
  [call-with-escape-continuation (known-procedure 2)]
  [call-with-immediate-continuation-mark (known-procedure 12)]
  [call-with-input-file (known-procedure 12)]
  [call-with-output-file (known-procedure 28)]
  [call-with-semaphore (known-procedure -4)]
  [call-with-semaphore/enable-break (known-procedure -4)]
  [call-with-values (known-procedure 4)]
  [car (known-procedure 2)]
  [cdaaar (known-procedure 2)]
  [cdaadr (known-procedure 2)]
  [cdaar (known-procedure 2)]
  [cdadar (known-procedure 2)]
  [cdaddr (known-procedure 2)]
  [cdadr (known-procedure 2)]
  [cdar (known-procedure 2)]
  [cddaar (known-procedure 2)]
  [cddadr (known-procedure 2)]
  [cddar (known-procedure 2)]
  [cdddar (known-procedure 2)]
  [cddddr (known-procedure 2)]
  [cdddr (known-procedure 2)]
  [cddr (known-procedure 2)]
  [cdr (known-procedure 2)]
  [ceiling (known-procedure 2)]
  [channel-put-evt (known-procedure 4)]
  [channel-put-evt? (known-procedure/pure 2)]
  [channel? (known-procedure/pure 2)]
  [chaperone-box (known-procedure -8)]
  [chaperone-channel (known-procedure -8)]
  [chaperone-continuation-mark-key (known-procedure -8)]
  [chaperone-evt (known-procedure -4)]
  [chaperone-hash (known-procedure -32)]
  [chaperone-of? (known-procedure 4)]
  [chaperone-procedure (known-procedure -4)]
  [chaperone-procedure* (known-procedure -4)]
  [chaperone-prompt-tag (known-procedure -8)]
  [chaperone-struct (known-procedure -2)]
  [chaperone-struct-type (known-procedure -16)]
  [chaperone-vector (known-procedure -8)]
  [chaperone-vector* (known-procedure -8)]
  [chaperone? (known-procedure/pure 2)]
  [char->integer (known-procedure 2)]
  [char-alphabetic? (known-procedure 2)]
  [char-blank? (known-procedure 2)]
  [char-ci<=? (known-procedure -2)]
  [char-ci<? (known-procedure -2)]
  [char-ci=? (known-procedure -2)]
  [char-ci>=? (known-procedure -2)]
  [char-ci>? (known-procedure -2)]
  [char-downcase (known-procedure 2)]
  [char-foldcase (known-procedure 2)]
  [char-general-category (known-procedure 2)]
  [char-graphic? (known-procedure 2)]
  [char-iso-control? (known-procedure 2)]
  [char-lower-case? (known-procedure 2)]
  [char-numeric? (known-procedure 2)]
  [char-punctuation? (known-procedure 2)]
  [char-ready? (known-procedure 3)]
  [char-symbolic? (known-procedure 2)]
  [char-title-case? (known-procedure 2)]
  [char-titlecase (known-procedure 2)]
  [char-upcase (known-procedure 2)]
  [char-upper-case? (known-procedure 2)]
  [char-utf-8-length (known-procedure 2)]
  [char-whitespace? (known-procedure 2)]
  [char<=? (known-procedure -2)]
  [char<? (known-procedure -2)]
  [char=? (known-procedure -2)]
  [char>=? (known-procedure -2)]
  [char>? (known-procedure -2)]
  [char? (known-procedure/pure 2)]
  [checked-procedure-check-and-extract (known-procedure 32)]
  [choice-evt (known-procedure -1)]
  [cleanse-path (known-procedure 2)]
  [close-input-port (known-procedure 2)]
  [close-output-port (known-procedure 2)]
  [collect-garbage (known-procedure 3)]
  [compile (known-procedure 2)]
  [compile-allow-set!-undefined (known-constant)]
  [compile-context-preservation-enabled (known-constant)]
  [compile-enforce-module-constants (known-constant)]
  [compile-target-machine? (known-procedure 2)]
  [complete-path? (known-procedure 2)]
  [complex? (known-procedure/pure 2)]
  [cons (known-procedure/pure 4)]
  [continuation-mark-key? (known-procedure/pure 2)]
  [continuation-mark-set->context (known-procedure 2)]
  [continuation-mark-set->list (known-procedure 12)]
  [continuation-mark-set->list* (known-procedure 28)]
  [continuation-mark-set-first (known-procedure 28)]
  [continuation-mark-set? (known-procedure/pure 2)]
  [continuation-marks (known-procedure 6)]
  [continuation-prompt-available? (known-procedure 6)]
  [continuation-prompt-tag? (known-procedure/pure 2)]
  [continuation? (known-procedure/pure 2)]
  [copy-file (known-procedure 12)]
  [cos (known-procedure 2)]
  [current-code-inspector (known-constant)]
  [current-command-line-arguments (known-constant)]
  [current-compile-target-machine (known-constant)]
  [current-continuation-marks (known-procedure 3)]
  [current-custodian (known-constant)]
  [current-directory (known-constant)]
  [current-directory-for-user (known-constant)]
  [current-drive (known-procedure 1)]
  [current-environment-variables (known-constant)]
  [current-error-port (known-constant)]
  [current-evt-pseudo-random-generator (known-constant)]
  [current-force-delete-permissions (known-constant)]
  [current-gc-milliseconds (known-procedure 1)]
  [current-get-interaction-input-port (known-constant)]
  [current-inexact-milliseconds (known-procedure 1)]
  [current-input-port (known-constant)]
  [current-inspector (known-constant)]
  [current-load-extension (known-constant)]
  [current-load-relative-directory (known-constant)]
  [current-locale (known-constant)]
  [current-logger (known-constant)]
  [current-memory-use (known-procedure 3)]
  [current-milliseconds (known-procedure 1)]
  [current-output-port (known-constant)]
  [current-plumber (known-constant)]
  [current-preserved-thread-cell-values (known-procedure 3)]
  [current-print (known-constant)]
  [current-process-milliseconds (known-procedure 3)]
  [current-prompt-read (known-constant)]
  [current-pseudo-random-generator (known-constant)]
  [current-read-interaction (known-constant)]
  [current-seconds (known-procedure 1)]
  [current-security-guard (known-constant)]
  [current-subprocess-custodian-mode (known-constant)]
  [current-thread (known-procedure 1)]
  [current-thread-group (known-constant)]
  [current-thread-initial-stack-size (known-constant)]
  [current-write-relative-directory (known-constant)]
  [custodian-box-value (known-procedure 2)]
  [custodian-box? (known-procedure/pure 2)]
  [custodian-limit-memory (known-procedure 12)]
  [custodian-managed-list (known-procedure 4)]
  [custodian-memory-accounting-available? (known-procedure 1)]
  [custodian-require-memory (known-procedure 8)]
  [custodian-shut-down? (known-procedure 2)]
  [custodian-shutdown-all (known-procedure 2)]
  [custodian? (known-procedure/pure 2)]
  [custom-print-quotable-accessor (known-procedure 2)]
  [custom-print-quotable? (known-procedure 2)]
  [custom-write-accessor (known-procedure 2)]
  [custom-write? (known-procedure/pure 2)]
  [date (known-constant)]
  [date* (known-constant)]
  [date*-nanosecond (known-procedure 2)]
  [date*-time-zone-name (known-procedure 2)]
  [date*? (known-procedure/pure 2)]
  [date-day (known-procedure 2)]
  [date-dst? (known-procedure 2)]
  [date-hour (known-procedure 2)]
  [date-minute (known-procedure 2)]
  [date-month (known-procedure 2)]
  [date-second (known-procedure 2)]
  [date-time-zone-offset (known-procedure 2)]
  [date-week-day (known-procedure 2)]
  [date-year (known-procedure 2)]
  [date-year-day (known-procedure 2)]
  [date? (known-procedure/pure 2)]
  [datum->syntax (known-procedure 60)]
  [datum-intern-literal (known-procedure 2)]
  [default-continuation-prompt-tag (known-procedure/pure 1)]
  [delete-directory (known-procedure 2)]
  [delete-file (known-procedure 2)]
  [denominator (known-procedure 2)]
  [directory-exists? (known-procedure 2)]
  [directory-list (known-procedure 3)]
  [display (known-procedure 6)]
  [double-flonum? (known-procedure/pure 2)]
  [dump-memory-stats (known-procedure -1)]
  [dynamic-wind (known-procedure 8)]
  [environment-variables-copy (known-procedure 2)]
  [environment-variables-names (known-procedure 2)]
  [environment-variables-ref (known-procedure 4)]
  [environment-variables-set! (known-procedure 24)]
  [environment-variables? (known-procedure/pure 2)]
  [eof (known-constant)]
  [eof-object? (known-procedure/pure 2)]
  [ephemeron-value (known-procedure 6)]
  [ephemeron? (known-procedure/pure 2)]
  [eprintf (known-procedure -2)]
  [eq-hash-code (known-procedure 2)]
  [eq? (known-procedure/pure 4)]
  [equal-hash-code (known-procedure 2)]
  [equal-secondary-hash-code (known-procedure 2)]
  [equal? (known-procedure 4)]
  [equal?/recur (known-procedure 8)]
  [eqv-hash-code (known-procedure 2)]
  [eqv? (known-procedure/pure 4)]
  [error (known-procedure -2)]
  [error-display-handler (known-constant)]
  [error-escape-handler (known-constant)]
  [error-print-context-length (known-constant)]
  [error-print-source-location (known-constant)]
  [error-print-width (known-constant)]
  [error-value->string-handler (known-constant)]
  [eval-jit-enabled (known-constant)]
  [even? (known-procedure 2)]
  [evt? (known-procedure/pure 2)]
  [exact->inexact (known-procedure 2)]
  [exact-integer? (known-procedure/pure 2)]
  [exact-nonnegative-integer? (known-procedure/pure 2)]
  [exact-positive-integer? (known-procedure/pure 2)]
  [exact? (known-procedure 2)]
  [executable-yield-handler (known-constant)]
  [exit (known-procedure 3)]
  [exit-handler (known-constant)]
  [exn (known-constant)]
  [exn-continuation-marks (known-procedure 2)]
  [exn-message (known-procedure 2)]
  [exn:break (known-constant)]
  [exn:break-continuation (known-procedure 2)]
  [exn:break:hang-up (known-constant)]
  [exn:break:hang-up? (known-procedure/pure 2)]
  [exn:break:terminate (known-constant)]
  [exn:break:terminate? (known-procedure/pure 2)]
  [exn:break? (known-procedure/pure 2)]
  [exn:fail (known-constant)]
  [exn:fail:contract (known-constant)]
  [exn:fail:contract:arity (known-constant)]
  [exn:fail:contract:arity? (known-procedure/pure 2)]
  [exn:fail:contract:continuation (known-constant)]
  [exn:fail:contract:continuation? (known-procedure/pure 2)]
  [exn:fail:contract:divide-by-zero (known-constant)]
  [exn:fail:contract:divide-by-zero? (known-procedure/pure 2)]
  [exn:fail:contract:non-fixnum-result (known-constant)]
  [exn:fail:contract:non-fixnum-result? (known-procedure/pure 2)]
  [exn:fail:contract:variable (known-constant)]
  [exn:fail:contract:variable-id (known-procedure 2)]
  [exn:fail:contract:variable? (known-procedure/pure 2)]
  [exn:fail:contract? (known-procedure/pure 2)]
  [exn:fail:filesystem (known-constant)]
  [exn:fail:filesystem:errno (known-constant)]
  [exn:fail:filesystem:errno-errno (known-procedure 2)]
  [exn:fail:filesystem:errno? (known-procedure/pure 2)]
  [exn:fail:filesystem:exists (known-constant)]
  [exn:fail:filesystem:exists? (known-procedure 2)]
  [exn:fail:filesystem:version (known-constant)]
  [exn:fail:filesystem:version? (known-procedure/pure 2)]
  [exn:fail:filesystem? (known-procedure 2)]
  [exn:fail:network (known-constant)]
  [exn:fail:network:errno (known-constant)]
  [exn:fail:network:errno-errno (known-procedure 2)]
  [exn:fail:network:errno? (known-procedure/pure 2)]
  [exn:fail:network? (known-procedure 2)]
  [exn:fail:out-of-memory (known-constant)]
  [exn:fail:out-of-memory? (known-procedure/pure 2)]
  [exn:fail:read (known-constant)]
  [exn:fail:read-srclocs (known-procedure 2)]
  [exn:fail:read:eof (known-constant)]
  [exn:fail:read:eof? (known-procedure/pure 2)]
  [exn:fail:read:non-char (known-constant)]
  [exn:fail:read:non-char? (known-procedure/pure 2)]
  [exn:fail:read? (known-procedure 2)]
  [exn:fail:unsupported (known-constant)]
  [exn:fail:unsupported? (known-procedure/pure 2)]
  [exn:fail:user (known-constant)]
  [exn:fail:user? (known-procedure/pure 2)]
  [exn:fail? (known-procedure/pure 2)]
  [exn:srclocs-accessor (known-procedure 2)]
  [exn:srclocs? (known-procedure/pure 2)]
  [exn? (known-procedure/pure 2)]
  [exp (known-procedure 2)]
  [expand-user-path (known-procedure 2)]
  [explode-path (known-procedure 2)]
  [expt (known-procedure 4)]
  [file-exists? (known-procedure 2)]
  [file-or-directory-identity (known-procedure 6)]
  [file-or-directory-modify-seconds (known-procedure 14)]
  [file-or-directory-permissions (known-procedure 6)]
  [file-position (known-procedure 6)]
  [file-position* (known-procedure 2)]
  [file-size (known-procedure 2)]
  [file-stream-buffer-mode (known-procedure 6)]
  [file-stream-port? (known-procedure 2)]
  [file-truncate (known-procedure 4)]
  [filesystem-change-evt (known-procedure 6)]
  [filesystem-change-evt-cancel (known-procedure 2)]
  [filesystem-change-evt? (known-procedure/pure 2)]
  [filesystem-root-list (known-procedure 1)]
  [find-system-path (known-procedure 2)]
  [fixnum? (known-procedure/pure 2)]
  [floating-point-bytes->real (known-procedure 30)]
  [flonum? (known-procedure/pure 2)]
  [floor (known-procedure 2)]
  [flush-output (known-procedure 3)]
  [for-each (known-procedure -4)]
  [format (known-procedure -2)]
  [fprintf (known-procedure -4)]
  [gcd (known-procedure -1)]
  [gensym (known-procedure 3)]
  [get-output-bytes (known-procedure 30)]
  [get-output-string (known-procedure 2)]
  [global-port-print-handler (known-constant)]
  [handle-evt (known-procedure 4)]
  [handle-evt? (known-procedure/pure 2)]
  [hash (known-procedure -1)]
  [hash-clear (known-procedure 2)]
  [hash-clear! (known-procedure 2)]
  [hash-copy (known-procedure 2)]
  [hash-count (known-procedure 2)]
  [hash-eq? (known-procedure 2)]
  [hash-equal? (known-procedure 2)]
  [hash-eqv? (known-procedure 2)]
  [hash-for-each (known-procedure 12)]
  [hash-iterate-first (known-procedure 2)]
  [hash-iterate-key (known-procedure 4)]
  [hash-iterate-key+value (known-procedure 4)]
  [hash-iterate-next (known-procedure 4)]
  [hash-iterate-pair (known-procedure 4)]
  [hash-iterate-value (known-procedure 4)]
  [hash-keys-subset? (known-procedure 4)]
  [hash-map (known-procedure 12)]
  [hash-placeholder? (known-procedure/pure 2)]
  [hash-ref (known-procedure 12)]
  [hash-remove (known-procedure 4)]
  [hash-remove! (known-procedure 4)]
  [hash-set (known-procedure 8)]
  [hash-set! (known-procedure 8)]
  [hash-weak? (known-procedure 2)]
  [hash? (known-procedure/pure 2)]
  [hasheq (known-procedure -1)]
  [hasheqv (known-procedure -1)]
  [imag-part (known-procedure 2)]
  [immutable? (known-procedure/pure 2)]
  [impersonate-box (known-procedure -8)]
  [impersonate-channel (known-procedure -8)]
  [impersonate-continuation-mark-key (known-procedure -8)]
  [impersonate-hash (known-procedure -32)]
  [impersonate-procedure (known-procedure -4)]
  [impersonate-procedure* (known-procedure -4)]
  [impersonate-prompt-tag (known-procedure -8)]
  [impersonate-struct (known-procedure -2)]
  [impersonate-vector (known-procedure -8)]
  [impersonate-vector* (known-procedure -8)]
  [impersonator-ephemeron (known-procedure 2)]
  [impersonator-of? (known-procedure 4)]
  [impersonator-prop:application-mark (known-constant)]
  [impersonator-property-accessor-procedure? (known-procedure 2)]
  [impersonator-property? (known-procedure/pure 2)]
  [impersonator? (known-procedure/pure 2)]
  [inexact->exact (known-procedure 2)]
  [inexact-real? (known-procedure/pure 2)]
  [inexact? (known-procedure 2)]
  [input-port? (known-procedure/pure 2)]
  [inspector-superior? (known-procedure 4)]
  [inspector? (known-procedure/pure 2)]
  [integer->char (known-procedure 2)]
  [integer->integer-bytes (known-procedure 120)]
  [integer-bytes->integer (known-procedure 60)]
  [integer-length (known-procedure 2)]
  [integer-sqrt (known-procedure 2)]
  [integer-sqrt/remainder (known-procedure 2)]
  [integer? (known-procedure/pure 2)]
  [interned-char? (known-procedure/pure 2)]
  [keyword->string (known-procedure 2)]
  [keyword<? (known-procedure -2)]
  [keyword? (known-procedure/pure 2)]
  [kill-thread (known-procedure 2)]
  [lcm (known-procedure -1)]
  [length (known-procedure 2)]
  [link-exists? (known-procedure 2)]
  [list (known-procedure/pure -1)]
  [list* (known-procedure/pure -2)]
  [list->bytes (known-procedure 2)]
  [list->string (known-procedure 2)]
  [list->vector (known-procedure 2)]
  [list-pair? (known-procedure/pure 2)]
  [list-ref (known-procedure 4)]
  [list-tail (known-procedure 4)]
  [list? (known-procedure/pure 2)]
  [load-on-demand-enabled (known-constant)]
  [locale-string-encoding (known-procedure 1)]
  [log (known-procedure 6)]
  [log-all-levels (known-procedure 2)]
  [log-level-evt (known-procedure 2)]
  [log-level? (known-procedure 12)]
  [log-max-level (known-procedure 6)]
  [log-message (known-procedure 112)]
  [log-receiver? (known-procedure/pure 2)]
  [logger-name (known-procedure 2)]
  [logger? (known-procedure/pure 2)]
  [magnitude (known-procedure 2)]
  [make-bytes (known-procedure 6)]
  [make-channel (known-procedure/pure 1)]
  [make-continuation-mark-key (known-procedure 3)]
  [make-continuation-prompt-tag (known-procedure 3)]
  [make-custodian (known-procedure 3)]
  [make-custodian-box (known-procedure 4)]
  [make-date (known-constant)]
  [make-date* (known-constant)]
  [make-derived-parameter (known-procedure 8)]
  [make-directory (known-procedure 2)]
  [make-environment-variables (known-procedure -1)]
  [make-ephemeron (known-procedure/pure 4)]
  [make-file-or-directory-link (known-procedure 4)]
  [make-hash (known-procedure 3)]
  [make-hash-placeholder (known-procedure 2)]
  [make-hasheq (known-procedure 3)]
  [make-hasheq-placeholder (known-procedure 2)]
  [make-hasheqv (known-procedure 3)]
  [make-hasheqv-placeholder (known-procedure 2)]
  [make-immutable-hash (known-procedure 3)]
  [make-immutable-hasheq (known-procedure 3)]
  [make-immutable-hasheqv (known-procedure 3)]
  [make-impersonator-property (known-procedure 2)]
  [make-input-port (known-procedure 2032)]
  [make-inspector (known-procedure 3)]
  [make-known-char-range-list (known-procedure/pure 1)]
  [make-log-receiver (known-procedure -4)]
  [make-logger (known-procedure -1)]
  [make-output-port (known-procedure 4080)]
  [make-parameter (known-procedure 6)]
  [make-phantom-bytes (known-procedure 2)]
  [make-pipe (known-procedure 15)]
  [make-placeholder (known-procedure/pure 2)]
  [make-plumber (known-procedure/pure 1)]
  [make-polar (known-procedure 4)]
  [make-prefab-struct (known-procedure -2)]
  [make-pseudo-random-generator (known-procedure 1)] ; not pure, depends on (current-milliseconds)
  [make-reader-graph (known-procedure 2)]
  [make-rectangular (known-procedure 4)]
  [make-security-guard (known-procedure 24)]
  [make-semaphore (known-procedure 3)]
  [make-shared-bytes (known-procedure 6)]
  [make-sibling-inspector (known-procedure 3)]
  [make-string (known-procedure 6)]
  [make-struct-field-accessor (known-procedure 12)]
  [make-struct-field-mutator (known-procedure 12)]
  [make-struct-type (known-procedure 4080)]
  [make-struct-type-property (known-procedure 30)]
  [make-thread-cell (known-procedure/pure 6)]
  [make-thread-group (known-procedure 3)]
  [make-vector (known-procedure 6)]
  [make-weak-box (known-procedure/pure 2)]
  [make-weak-hash (known-procedure 3)]
  [make-weak-hasheq (known-procedure 3)]
  [make-weak-hasheqv (known-procedure 3)]
  [make-will-executor (known-procedure/pure 1)]
  [map (known-procedure -4)]
  [max (known-procedure -2)]
  [mcar (known-procedure 2)]
  [mcdr (known-procedure 2)]
  [mcons (known-procedure/pure 4)]
  [min (known-procedure -2)]
  [modulo (known-procedure 4)]
  [mpair? (known-procedure/pure 2)]
  [nack-guard-evt (known-procedure 2)]
  [negative? (known-procedure 2)]
  [never-evt (known-constant)]
  [newline (known-procedure 3)]
  [not (known-procedure/pure 2)]
  [null (known-literal '(quote ()))]
  [null? (known-procedure/pure 2)]
  [number->string (known-procedure 6)]
  [number? (known-procedure/pure 2)]
  [numerator (known-procedure 2)]
  [object-name (known-procedure 2)]
  [odd? (known-procedure 2)]
  [open-input-bytes (known-procedure 6)]
  [open-input-file (known-procedure 14)]
  [open-input-output-file (known-procedure 14)]
  [open-input-string (known-procedure 6)]
  [open-output-bytes (known-procedure 3)]
  [open-output-file (known-procedure 14)]
  [open-output-string (known-procedure 3)]
  [ormap (known-procedure -4)]
  [output-port? (known-procedure/pure 2)]
  [pair? (known-procedure/pure 2)]
  [parameter-procedure=? (known-procedure 4)]
  [parameter? (known-procedure/pure 2)]
  [parameterization? (known-procedure/pure 2)]
  [path->bytes (known-procedure 2)]
  [path->complete-path (known-procedure 6)]
  [path->directory-path (known-procedure 2)]
  [path->string (known-procedure 2)]
  [path-convention-type (known-procedure 2)]
  [path-element->bytes (known-procedure 2)]
  [path-element->string (known-procedure 2)]
  [path-for-some-system? (known-procedure/pure 2)]
  [path<? (known-procedure -2)]
  [path? (known-procedure/pure 2)]
  [peek-byte (known-procedure 7)]
  [peek-byte-or-special (known-procedure 63)]
  [peek-bytes (known-procedure 12)]
  [peek-bytes! (known-procedure 60)]
  [peek-bytes-avail! (known-procedure 124)]
  [peek-bytes-avail!* (known-procedure 124)]
  [peek-bytes-avail!/enable-break (known-procedure 124)]
  [peek-char (known-procedure 7)]
  [peek-char-or-special (known-procedure 31)]
  [peek-string (known-procedure 12)]
  [peek-string! (known-procedure 60)]
  [phantom-bytes? (known-procedure/pure 2)]
  [pipe-content-length (known-procedure 2)]
  [placeholder-get (known-procedure 2)]
  [placeholder-set! (known-procedure 4)]
  [placeholder? (known-procedure/pure 2)]
  [plumber-add-flush! (known-procedure 12)]
  [plumber-flush-all (known-procedure 2)]
  [plumber-flush-handle-remove! (known-procedure 2)]
  [plumber-flush-handle? (known-procedure/pure 2)]
  [plumber? (known-procedure/pure 2)]
  [poll-guard-evt (known-procedure 2)]
  [port-closed-evt (known-procedure 3)]
  [port-closed? (known-procedure 2)]
  [port-commit-peeked (known-procedure 24)]
  [port-count-lines! (known-procedure 2)]
  [port-count-lines-enabled (known-constant)]
  [port-counts-lines? (known-procedure 2)]
  [port-display-handler (known-procedure 6)]
  [port-file-identity (known-procedure 2)]
  [port-file-unlock (known-procedure 2)]
  [port-next-location (known-procedure 2)]
  [port-print-handler (known-procedure 6)]
  [port-progress-evt (known-procedure 3)]
  [port-provides-progress-evts? (known-procedure 2)]
  [port-read-handler (known-procedure 6)]
  [port-try-file-lock? (known-procedure 4)]
  [port-write-handler (known-procedure 6)]
  [port-writes-atomic? (known-procedure 2)]
  [port-writes-special? (known-procedure 2)]
  [positive? (known-procedure 2)]
  [prefab-key->struct-type (known-procedure 4)]
  [prefab-key? (known-procedure 2)] ; not pure, the argument may have a mutable vector
  [prefab-struct-key (known-procedure 2)]
  [pregexp (known-procedure 6)]
  [pregexp? (known-procedure/pure 2)]
  [primitive-closure? (known-procedure/pure 2)]
  [primitive-result-arity (known-procedure 2)]
  [primitive? (known-procedure/pure 2)]
  [print (known-procedure 14)]
  [print-as-expression (known-constant)]
  [print-boolean-long-form (known-constant)]
  [print-box (known-constant)]
  [print-graph (known-constant)]
  [print-hash-table (known-constant)]
  [print-mpair-curly-braces (known-constant)]
  [print-pair-curly-braces (known-constant)]
  [print-reader-abbreviations (known-constant)]
  [print-struct (known-constant)]
  [print-syntax-width (known-constant)]
  [print-unreadable (known-constant)]
  [print-vector-length (known-constant)]
  [printf (known-procedure -2)]
  [procedure->method (known-procedure 2)]
  [procedure-arity (known-procedure 2)]
  [procedure-arity-mask (known-procedure 2)]
  [procedure-arity-includes? (known-procedure 12)]
  [procedure-arity? (known-procedure/pure 2)]
  [procedure-closure-contents-eq? (known-procedure 4)]
  [procedure-extract-target (known-procedure 2)]
  [procedure-impersonator*? (known-procedure/pure 2)]
  [procedure-reduce-arity (known-procedure 12)]
  [procedure-reduce-arity-mask (known-procedure 12)]
  [procedure-rename (known-procedure 4)]
  [procedure-result-arity (known-procedure 2)]
  [procedure-specialize (known-procedure 2)]
  [procedure-struct-type? (known-procedure 2)]
  [procedure? (known-procedure/pure 2)]
  [progress-evt? (known-procedure 6)]
  [prop:arity-string (known-constant)]
  [prop:authentic (known-struct-type-property/immediate-guard)]
  [prop:checked-procedure (known-constant)]
  [prop:custom-print-quotable (known-constant)]
  [prop:custom-write (known-struct-type-property/immediate-guard)]
  [prop:equal+hash (known-struct-type-property/immediate-guard)]
  [prop:evt (known-struct-type-property/immediate-guard)]
  [prop:exn:srclocs (known-constant)]
  [prop:impersonator-of (known-constant)]
  [prop:incomplete-arity (known-constant)]
  [prop:input-port (known-constant)]
  [prop:method-arity-error (known-constant)]
  [prop:object-name (known-constant)]
  [prop:output-port (known-constant)]
  [prop:procedure (known-struct-type-property/immediate-guard)]
  [pseudo-random-generator->vector (known-procedure 2)]
  [pseudo-random-generator-vector? (known-procedure 2)]
  [pseudo-random-generator? (known-procedure/pure 2)]
  [quotient (known-procedure 4)]
  [quotient/remainder (known-procedure 4)]
  [raise (known-procedure 6)]
  [raise-argument-error (known-procedure -8)]
  [raise-arguments-error (known-procedure -4)]
  [raise-arity-error (known-procedure -4)]
  [raise-arity-mask-error (known-procedure -4)]
  [raise-mismatch-error (known-procedure -8)]
  [raise-range-error (known-procedure 384)]
  [raise-result-error (known-procedure -8)]
  [raise-result-arity-error (known-procedure -16)]
  [raise-type-error (known-procedure -8)]
  [raise-user-error (known-procedure -2)]
  [random (known-procedure 7)]
  [random-seed (known-procedure 2)]
  [rational? (known-procedure/pure 2)]
  [read-accept-bar-quote (known-constant)]
  [read-byte (known-procedure 3)]
  [read-byte-or-special (known-procedure 15)]
  [read-bytes (known-procedure 6)]
  [read-bytes! (known-procedure 30)]
  [read-bytes-avail! (known-procedure 30)]
  [read-bytes-avail!* (known-procedure 30)]
  [read-bytes-avail!/enable-break (known-procedure 30)]
  [read-bytes-line (known-procedure 7)]
  [read-case-sensitive (known-constant)]
  [read-char (known-procedure 3)]
  [read-char-or-special (known-procedure 15)]
  [read-line (known-procedure 7)]
  [read-on-demand-source (known-constant)]
  [read-string (known-procedure 6)]
  [read-string! (known-procedure 30)]
  [real->double-flonum (known-procedure 2)]
  [real->floating-point-bytes (known-procedure 60)]
  [real->single-flonum (known-procedure 2)]
  [real-part (known-procedure 2)]
  [real? (known-procedure/pure 2)]
  [regexp (known-procedure 6)]
  [regexp-match (known-procedure 124)]
  [regexp-match-peek (known-procedure 124)]
  [regexp-match-peek-immediate (known-procedure 124)]
  [regexp-match-peek-positions (known-procedure 124)]
  [regexp-match-peek-positions-immediate (known-procedure 124)]
  [regexp-match-peek-positions-immediate/end (known-procedure 252)]
  [regexp-match-peek-positions/end (known-procedure 252)]
  [regexp-match-positions (known-procedure 124)]
  [regexp-match-positions/end (known-procedure 252)]
  [regexp-match/end (known-procedure 252)]
  [regexp-match? (known-procedure 124)]
  [regexp-max-lookbehind (known-procedure 2)]
  [regexp-replace (known-procedure 24)]
  [regexp-replace* (known-procedure 24)]
  [regexp? (known-procedure/pure 2)]
  [relative-path? (known-procedure 2)]
  [remainder (known-procedure 4)]
  [rename-file-or-directory (known-procedure 12)]
  [replace-evt (known-procedure 4)]
  [resolve-path (known-procedure 2)]
  [reverse (known-procedure 2)]
  [round (known-procedure 2)]
  [seconds->date (known-procedure 6)]
  [security-guard? (known-procedure/pure 2)]
  [semaphore-peek-evt (known-procedure 2)]
  [semaphore-peek-evt? (known-procedure/pure 2)]
  [semaphore-post (known-procedure 2)]
  [semaphore-try-wait? (known-procedure 2)]
  [semaphore-wait (known-procedure 2)]
  [semaphore-wait/enable-break (known-procedure 2)]
  [semaphore? (known-procedure/pure 2)]
  [set-box! (known-procedure 4)]
  [set-box*! (known-procedure 4)]
  [set-mcar! (known-procedure 4)]
  [set-mcdr! (known-procedure 4)]
  [set-phantom-bytes! (known-procedure 4)]
  [set-port-next-location! (known-procedure 16)]
  [sha1-bytes (known-procedure 14)]
  [sha224-bytes (known-procedure 14)]
  [sha256-bytes (known-procedure 14)]
  [shared-bytes (known-procedure -1)]
  [shell-execute (known-procedure 32)]
  [simplify-path (known-procedure 6)]
  [sin (known-procedure 2)]
  [single-flonum? (known-procedure/pure 2)]
  [sleep (known-procedure 3)]
  [split-path (known-procedure 2)]
  [sqrt (known-procedure 2)]
  [srcloc (known-constant)]
  [srcloc->string (known-procedure 2)]
  [srcloc-column (known-procedure 2)]
  [srcloc-line (known-procedure 2)]
  [srcloc-position (known-procedure 2)]
  [srcloc-source (known-procedure 2)]
  [srcloc-span (known-procedure 2)]
  [srcloc? (known-procedure/pure 2)]
  [string (known-procedure -1)]
  [string->bytes/latin-1 (known-procedure 30)]
  [string->bytes/locale (known-procedure 30)]
  [string->bytes/utf-8 (known-procedure 30)]
  [string->immutable-string (known-procedure 2)]
  [string->keyword (known-procedure 2)]
  [string->list (known-procedure 2)]
  [string->number (known-procedure 30)]
  [string->path (known-procedure 2)]
  [string->path-element (known-procedure 2)]
  [string->symbol (known-procedure 2)]
  [string->uninterned-symbol (known-procedure 2)]
  [string->unreadable-symbol (known-procedure 2)]
  [string-append (known-procedure -1)]
  [string-ci<=? (known-procedure -2)]
  [string-ci<? (known-procedure -2)]
  [string-ci=? (known-procedure -2)]
  [string-ci>=? (known-procedure -2)]
  [string-ci>? (known-procedure -2)]
  [string-copy (known-procedure 2)]
  [string-copy! (known-procedure 56)]
  [string-downcase (known-procedure 2)]
  [string-fill! (known-procedure 4)]
  [string-foldcase (known-procedure 2)]
  [string-length (known-procedure 2)]
  [string-locale-ci<? (known-procedure -2)]
  [string-locale-ci=? (known-procedure -2)]
  [string-locale-ci>? (known-procedure -2)]
  [string-locale-downcase (known-procedure 2)]
  [string-locale-upcase (known-procedure 2)]
  [string-locale<? (known-procedure -2)]
  [string-locale=? (known-procedure -2)]
  [string-locale>? (known-procedure -2)]
  [string-normalize-nfc (known-procedure 2)]
  [string-normalize-nfd (known-procedure 2)]
  [string-normalize-nfkc (known-procedure 2)]
  [string-normalize-nfkd (known-procedure 2)]
  [string-port? (known-procedure 2)]
  [string-ref (known-procedure 4)]
  [string-set! (known-procedure 8)]
  [string-titlecase (known-procedure 2)]
  [string-upcase (known-procedure 2)]
  [string-utf-8-length (known-procedure 14)]
  [string<=? (known-procedure -2)]
  [string<? (known-procedure -2)]
  [string=? (known-procedure -2)]
  [string>=? (known-procedure -2)]
  [string>? (known-procedure -2)]
  [string? (known-procedure/pure 2)]
  [struct->vector (known-procedure 6)]
  [struct-accessor-procedure? (known-procedure/pure 2)]
  [struct-constructor-procedure? (known-procedure/pure 2)]
  [struct-info (known-procedure 2)]
  [struct-mutator-procedure? (known-procedure/pure 2)]
  [struct-predicate-procedure? (known-procedure/pure 2)]
  [struct-type-info (known-procedure 2)]
  [struct-type-make-constructor (known-procedure 6)]
  [struct-type-make-predicate (known-procedure 2)]
  [struct-type-property-accessor-procedure? (known-procedure 2)]
  [struct-type-property? (known-procedure 2)]
  [struct-type? (known-procedure 2)]
  [struct:arity-at-least (known-constant)]
  [struct:date (known-constant)]
  [struct:date* (known-constant)]
  [struct:exn (known-constant)]
  [struct:exn:break (known-constant)]
  [struct:exn:break:hang-up (known-constant)]
  [struct:exn:break:terminate (known-constant)]
  [struct:exn:fail (known-constant)]
  [struct:exn:fail:contract (known-constant)]
  [struct:exn:fail:contract:arity (known-constant)]
  [struct:exn:fail:contract:continuation (known-constant)]
  [struct:exn:fail:contract:divide-by-zero (known-constant)]
  [struct:exn:fail:contract:non-fixnum-result (known-constant)]
  [struct:exn:fail:contract:variable (known-constant)]
  [struct:exn:fail:filesystem (known-constant)]
  [struct:exn:fail:filesystem:errno (known-constant)]
  [struct:exn:fail:filesystem:exists (known-constant)]
  [struct:exn:fail:filesystem:version (known-constant)]
  [struct:exn:fail:network (known-constant)]
  [struct:exn:fail:network:errno (known-constant)]
  [struct:exn:fail:out-of-memory (known-constant)]
  [struct:exn:fail:read (known-constant)]
  [struct:exn:fail:read:eof (known-constant)]
  [struct:exn:fail:read:non-char (known-constant)]
  [struct:exn:fail:unsupported (known-constant)]
  [struct:exn:fail:user (known-constant)]
  [struct:srcloc (known-constant)]
  [struct? (known-procedure 2)] ; not pure, depends on (current-inspector)
  [sub1 (known-procedure 2)]
  [subbytes (known-procedure 12)]
  [subprocess (known-procedure -16)]
  [subprocess-group-enabled (known-constant)]
  [subprocess-kill (known-procedure 4)]
  [subprocess-pid (known-procedure 2)]
  [subprocess-status (known-procedure 2)]
  [subprocess-wait (known-procedure 2)]
  [subprocess? (known-procedure 2)]
  [substring (known-procedure 12)]
  [symbol->string (known-procedure 2)]
  [symbol-interned? (known-procedure 2)]
  [symbol-unreadable? (known-procedure 2)]
  [symbol<? (known-procedure -2)]
  [symbol? (known-procedure/pure 2)]
  [sync (known-procedure -1)]
  [sync/enable-break (known-procedure -1)]
  [sync/timeout (known-procedure -2)]
  [sync/timeout/enable-break (known-procedure -2)]
  [syntax->datum (known-procedure 2)]
  [syntax-column (known-procedure 2)]
  [syntax-e (known-procedure 2)]
  [syntax-line (known-procedure 2)]
  [syntax-position (known-procedure 2)]
  [syntax-property (known-procedure 28)]
  [syntax-property-symbol-keys (known-procedure 2)]
  [syntax-source (known-procedure 2)]
  [syntax-span (known-procedure 2)]
  [syntax? (known-procedure/pure 2)]
  [system-big-endian? (known-procedure/pure 1)]
  [system-idle-evt (known-procedure/pure 1)]
  [system-language+country (known-procedure 1)]
  [system-library-subpath (known-procedure 3)]
  [system-path-convention-type (known-procedure/pure 1)]
  [system-type (known-procedure 3)]
  [tan (known-procedure 2)]
  [terminal-port? (known-procedure 2)]
  [thread (known-procedure 2)]
  [thread-cell-ref (known-procedure 2)]
  [thread-cell-set! (known-procedure 4)]
  [thread-cell-values? (known-procedure/pure 2)]
  [thread-cell? (known-procedure/pure 2)]
  [thread-dead-evt (known-procedure 2)]
  [thread-dead? (known-procedure 2)]
  [thread-group? (known-procedure/pure 2)]
  [thread-receive (known-procedure 1)]
  [thread-receive-evt (known-procedure/pure 1)]
  [thread-resume (known-procedure 6)]
  [thread-resume-evt (known-procedure 2)]
  [thread-rewind-receive (known-procedure 2)]
  [thread-running? (known-procedure 2)]
  [thread-send (known-procedure 12)]
  [thread-suspend (known-procedure 2)]
  [thread-suspend-evt (known-procedure 2)]
  [thread-try-receive (known-procedure 1)]
  [thread-wait (known-procedure 2)]
  [thread/suspend-to-kill (known-procedure 2)]
  [thread? (known-procedure/pure 2)]
  [time-apply (known-procedure 4)]
  [true-object? (known-procedure/pure 2)]
  [truncate (known-procedure 2)]
  [unbox (known-procedure 2)]
  [unbox* (known-procedure 2)]
  [uncaught-exception-handler (known-constant)]
  [unquoted-printing-string (known-procedure 2)]
  [unquoted-printing-string-value (known-procedure 2)]
  [unquoted-printing-string? (known-procedure 2)]
  [values (known-procedure -1)] ; not marked as pure, because it is not single valued
  [vector (known-procedure/pure -1)]
  [vector->immutable-vector (known-procedure 2)]
  [vector->list (known-procedure 2)]
  [vector->pseudo-random-generator (known-procedure 2)]
  [vector->pseudo-random-generator! (known-procedure 4)]
  [vector->values (known-procedure 14)]
  [vector-cas! (known-procedure 16)]
  [vector-copy! (known-procedure 56)]
  [vector-fill! (known-procedure 4)]
  [vector-immutable (known-procedure/pure -1)]
  [vector-length (known-procedure 2)]
  [vector-ref (known-procedure 4)]
  [vector-set! (known-procedure 8)]
  [vector-set-performance-stats! (known-procedure 6)]
  [vector? (known-procedure/pure 2)]
  [vector*-length (known-procedure 2)]
  [vector*-ref (known-procedure 4)]
  [vector*-set! (known-procedure 8)]
  [version (known-procedure/pure 1)]
  [void (known-procedure/pure -1)]
  [void? (known-procedure/pure 2)]
  [weak-box-value (known-procedure 6)]
  [weak-box? (known-procedure/pure 2)]
  [will-execute (known-procedure 2)]
  [will-executor? (known-procedure/pure 2)]
  [will-register (known-procedure 8)]
  [will-try-execute (known-procedure 2)]
  [with-input-from-file (known-procedure 12)]
  [with-output-to-file (known-procedure 28)]
  [wrap-evt (known-procedure 4)]
  [write (known-procedure 6)]
  [write-byte (known-procedure 6)]
  [write-bytes (known-procedure 30)]
  [write-bytes-avail (known-procedure 30)]
  [write-bytes-avail* (known-procedure 30)]
  [write-bytes-avail-evt (known-procedure 30)]
  [write-bytes-avail/enable-break (known-procedure 30)]
  [write-char (known-procedure 6)]
  [write-special (known-procedure 6)]
  [write-special-avail* (known-procedure 6)]
  [write-special-evt (known-procedure 4)]
  [write-string (known-procedure 30)]
  [zero? (known-procedure 2)])
