# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..10: "; }
END {print "not ok\n" unless $loaded;}
use RefDB::Pubmed;
$loaded = 1;
print "ok\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

my $numtest = 1;
my $numok = 1;

######################################################################
## Test Pubmed module

# Test 2
print "2..10: ";
$numtest++;

# check Pubmed normalization. Read a test file, write the normalization
# result to a temporary file, compare with a good output file 
my $infile = "testdata/testdata.in";

my $pm = new RefDB::Pubmed;

$pm->set_encodings("", "");

$pm->in($infile);

open OUT, "> testdata/testdata.out" or die "Cannot open output file. I'd like to write a file called testdata/testdata.out but you won't let me.\n";
select OUT;

while ((my $set = $pm->next_pubmed_set())) {
    $set->parse_pmset();
    print "\n";
    $set->dump_pmset_as_pm();
}

select STDOUT;

# the order the lines are dumped from the hash is system- and/or 
# version-dependent. Therefore we sort the output and compare it with
# a sorted good file. Sorting in turn is locale-dependent, so we make
# sure we use the C locale independent of the user's settings
if (system "LC_ALL=C sort < testdata/testdata.out | cmp -s - testdata/testdata_pm.good.sorted") {
    print "not ok\n";
}
else {
    print "ok\n";
    $numok++;
}

unlink "testdata/testdata.out";

# Test 3
print "3..10: ";
$numtest++;

# check Pubmed-to-RIS conversion. Read a test file, write the conversion
# result to a temporary file, compare with a good output file 
$infile = "testdata/testdata.in";

$pm = new RefDB::Pubmed;

$pm->set_encodings("", "");

$pm->in($infile);

open OUT, "> testdata/testdata.out" or die "Cannot open output file. I'd like to write a file called testdata/testdata.out but you won't let me.\n";
select OUT;

while ((my $set = $pm->next_pubmed_set())) {
    $set->parse_pmset();
    $set->convert_pmset();
    $set->dump_pmset_as_ris();
}

select STDOUT;

if (system "LC_ALL=C sort < testdata/testdata.out | cmp -s - testdata/testdata.good.sorted") {
    print "not ok\n";
}
else {
    print "ok\n";
    $numok++;
}

unlink "testdata/testdata.out";

print "4..10: ";
$numtest++;

# check Pubmed-to-RIS conversion from a string. Write the conversion
# result to a temporary file, compare with a good output file 
open IN, "< testdata/testdata.in";
my $instring;

# read test data into a string
while (<IN>) {
    $instring .= $_;
}

close IN;

$pm = new RefDB::Pubmed;

$pm->set_encodings("", "");

$pm->string($instring);

open OUT, "> testdata/testdata.out" or die "Cannot open output file. I'd like to write a file called testdata/testdata.out but you won't let me.\n";
select OUT;

while ((my $set = $pm->next_pubmed_set())) {
    $set->parse_pmset();
    $set->convert_pmset();
    $set->dump_pmset_as_ris();
}

select STDOUT;

if (system "LC_ALL=C sort < testdata/testdata.out | cmp -s - testdata/testdata.good.sorted") {
    print "not ok\n";
}
else {
    print "ok\n";
    $numok++;
}

unlink "testdata/testdata.out";

######################################################################
## Test CGI module

use RefDB::CGI;
print "5..10: ";
$numtest++;

## is_cgi() should return >0 if test.pl is run from the command line
if (RefDB::CGI::check_cgi("GET") > 0) {
    print "ok\n";
    $numok++;
}
else {
    print "not ok\n";
}

## load the version file directly and via load_html(), compare
print "6..10: ";
$numtest++;

$instring = "";

open IN, "< version";
while (<IN>) {
    $instring .= $_;
}
close IN;

my $loadstring = RefDB::CGI::load_html("version");

if ($instring eq $loadstring) {
    print "ok\n";
    $numok++;
}
else {
    print "not ok\n";
}

######################################################################
## Test Log module

use RefDB::Log;

print "7..10: ";
$numtest++;

## test num_loglevel(). Feed with alphanumeric, numeric, and incorrect
## level
if (RefDB::Log::num_loglevel("ERR") == 3) {
    if (RefDB::Log::num_loglevel(3) == 3) {
	if (RefDB::Log::num_loglevel("WOMBAT") == -1) {
	    print "ok\n";
	    $numok++;
	}
	else {
	    print "not ok\n";
	}
    }
    else {
	print "not ok\n";
    }
}

print "8..10: ";
$numtest++;

## test num_logdest(). Feed with alphanumeric, numeric, and incorrect
## level
if (RefDB::Log::num_logdest("SYSLOG") == 1) {
    if (RefDB::Log::num_logdest(2) == 2) {
	if (RefDB::Log::num_logdest("WOMBAT") == 0) {
	    print "ok\n";
	    $numok++;
	}
	else {
	    print "not ok\n";
	}
    }
    else {
	print "not ok\n";
    }
}

print "9..10: ";
$numtest++;

## test logging. In order to keep the system clean, we try to log to 
## a temp file
my $log = RefDB::Log::->new(2, 5, "testdata/testdata.log", "test.pl");

## this message should appear
$log->log_print(4, "first test message");

## this message should not appear
$log->log_print(7, "second test message");

$log->close();

$instring = "";

open IN, "< testdata/testdata.log";
while (<IN>) {
    $instring .= $_;
}
close IN;

unlink "testdata/testdata.log";

if (length($instring) == 0 || $instring =~ /second/) {
    print "not ok\n";
}
else {
    print "ok\n";
    $numok++;
}

######################################################################
## Test Prefs module

use RefDB::Prefs;
print "10..10: ";
$numtest++;

my $prefs = RefDB::Prefs::->new("testdata/testrc", undef);

if ($prefs->{outappend} eq "t") {
    print "ok\n";
    $numok++;
}
else {
    print "not ok\n";
}

######################################################################
## Grand finale

print "That is ... waitaminute ... $numok out of $numtest\n";
