/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  backend-dbib.h header file for backend-dbib.c
  markus@mhoenicka.de 2001-01-10

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include "mset.h"

int prepare_render_dbib(char** ptr_ref, size_t* ptr_ref_len, struct bibinfo* ptr_biblio_info, dbi_conn conn, int n_ref_format, const char* ns);
int finish_render_dbib(char** ptr_ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, struct bibinfo* ptr_biblio_info, char* table_name, struct CLIENT_REQUEST* ptr_clrequest, struct xmlindent* ptr_indent, int n_ref_format);
int render_dbib(char** ptr_ref, size_t* ref_len, struct BIBCONNS* ptr_bibconns, dbi_result dbires, const char* database, struct bibinfo* ptr_biblio_info, char* username, char* pdfroot, int nref_counter, short title_as_author, const char* ns, struct xmlindent* ptr_indent, int n_ref_format);
int format_entry(char** ptr_ref, size_t* ptr_ref_len, char* pubtype, struct BIBCONNS* ptr_bibconns, dbi_result dbiresref, dbi_result dbires, const char* database, const char* username, int nref_counter, struct mset* ptr_mset_sentinel, struct bibinfo* ptr_biblio_info, short title_as_author, const char* ns, struct xmlindent* ptr_indent, int n_ref_format, const char* pdfroot);

char* format_refnumber(char** ptr_ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, dbi_result dbires, dbi_result dbiresref, int nref_counter, int n_intext, const char* ns, struct xmlindent* ptr_indent, int n_ref_format);
char* format_citekey(char** ptr_ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, dbi_result dbires, dbi_result dbiresref, int n_intext, const char* ns, struct xmlindent* ptr_indent, int n_ref_format);
int format_authorlist(char** ptr_ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, dbi_result dbires, dbi_result dbiresref, int type, const char* database, int n_intext, struct bibinfo* ptr_biblio_info, short title_as_author, const char* ns, struct xmlindent* ptr_indent, int n_ref_format);
char* format_pubdate(char** ptr_ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, dbi_result dbires, dbi_result dbiresref, dbi_result dbirescit, int type, int n_intext, const char* year_unique_suffix, const char* ns, struct xmlindent* ptr_indent, int n_ref_format);
char* format_title(char** ptr_ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, dbi_result dbires, dbi_result dbires_ref, int type, int n_intext, int n_title_as_author, const char* ns, struct xmlindent* ptr_indent, int n_ref_format);
char* format_journalname(char** ptr_ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, dbi_result dbires, dbi_result dbires_ref, const char* database, int n_intext, const char* ns, struct xmlindent* ptr_indent, int n_ref_format, int n_title_as_author);
char* format_pages(char** ptr_ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, dbi_result dbires, dbi_result dbiresref, int n_intext, const char* ns, struct xmlindent* ptr_indent, int n_ref_format);
char* format_separator(char* ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, unsigned int n_separator_id, int n_ref_format);
char* format_simple(char** ptr_ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, dbi_result dbires, dbi_result dbires_ref, int n_intext, int n_item_index, int n_preceeding_index, int n_following_index, const char* elname, const char* ns, struct xmlindent* ptr_indent, int n_ref_format);
char* format_notes(char** ptr_ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, dbi_result dbires, dbi_result dbires_ref, const char* username, const char* ns, struct xmlindent* ptr_indent, int n_ref_format);

char* format_ulink(char** ptr_ref, size_t* ptr_ref_len, struct BIBCONNS* ptr_bibconns, dbi_result dbires, dbi_result dbires_ref, int type, int n_intext, int n_preceeding_index, int n_following_index, const char* ns, struct xmlindent* ptr_indent, int n_ref_format, const char* pdfroot);







