/* bib2ris.h: header file for bib2ris.c */
/* markus@mhoenicka.de 2001-8-24

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/* $Id: bib2ris.h,v 1.7 2002/12/13 20:34:30 mhoenicka Exp $ */

#define MAX_FIXFIELD_LEN 256
#define ERRMSG_LEN 512

/* structure for gathering the publication year information.
   fixed length strings are ok as len(PY) < 256 */
struct RISPY {
  char year[MAX_FIXFIELD_LEN];
  char month[MAX_FIXFIELD_LEN];
  char day[MAX_FIXFIELD_LEN];
  char edition[MAX_FIXFIELD_LEN];
  char howpublished[MAX_FIXFIELD_LEN];
};

/* structure for collecting all titles of the reference.
   need ptrs to allocated strings as there is no length limit */
struct TITLES {
  char* title;
  char* booktitle;
  char* seriestitle;
};

/* structure for collecting all notes of the reference.
   need ptrs to allocated strings as there is no length limit */
struct NOTES {
  char* annote;
  char* note;
};

/* structure for collecting all publisher infos of the reference.
   fixed length strings are ok as len(PB) < 256 */
struct PUBINFO {
  char institution[MAX_FIXFIELD_LEN];
  char organization[MAX_FIXFIELD_LEN];
  char publisher[MAX_FIXFIELD_LEN];
  char school[MAX_FIXFIELD_LEN];
};

/* definitions for checking completeness of entries */
#define BV_AUTHOR 0
#define BV_BOOKTITLE 1
#define BV_CHAPTER 2
#define BV_EDITOR 3
#define BV_INSTITUTION 4
#define BV_JOURNAL 5
#define BV_NOTE 6
#define BV_PAGES 7
#define BV_PUBLISHER 8
#define BV_SCHOOL 9
#define BV_TITLE 10
#define BV_YEAR 11

/* array of strings matching the above definitions for generating
   error messages */
const char bv_names[12][13] = {"author ", "booktitle ", "chapter ", "editor ", "institution ", "journal ", "note ", "pages ", "publisher ", "school ", "title ", "year "};

/* definitions for handling entry types */
#define BT_ARTICLE 0
#define BT_BOOK 1
#define BT_BOOKLET 2
#define BT_CONFERENCE 3
#define BT_INBOOK 4
#define BT_INCOLLECTION 5
#define BT_INPROCEEDINGS 6
#define BT_MANUAL 7
#define BT_MASTERSTHESIS 8
#define BT_MISC 9
#define BT_PHDTHESIS 10
#define BT_PROCEEDINGS 11
#define BT_TECHREPORT 12
#define BT_UNPUBLISHED 13

int process_bib(char* infile, int file);
int validate_bib(char* bib_type, char* bibvalid, AST* ptr_entry);
int fix_bibtypes(char mp_bibtypes[14][PREFS_BUF_LEN], int size);
char* print_type(char* bib_type, char** ris_type, AST* ptr_entry);
int print_journal(char* journal);
int print_py(struct RISPY* rispy);
int print_authors(char* authorstring, char* tagname, char* infile);
int print_titles(char* typestring, struct TITLES* titles);
int print_pubinfo(char* typestring, struct PUBINFO* pubinfo);
int print_notes(struct NOTES* notes);
int print_keywords(char* kwlist);
int print_poolstring(char* address, char* tag);
int print_pageinfo(char* pagestring);
char* get_year(char* bufstring, char* yearstring);
char* get_month(char* bufstring, char* monthstring);
char* get_day(char* bufstring, char* daystring);
char* find_num(char* bufstring, char* numstring, size_t len);
void pipehandler(int sig);
void log_print(int priority, char* string);

