#ifndef _RHEO_PSTREAM_H
#define _RHEO_PSTREAM_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/fdstream.h"
#include "rheolef/compiler.h"
namespace rheolef { 
class opstream : public fdostream {
  public:
    void open (const std::string& command) {
        setfd (make_fd (command));
    }
    void close () { 
	if (fp) pclose(fp);
	fp = 0;
    }
    opstream () : fdostream(0), fp(0) {}
    opstream (const std::string& command)
	: fdostream(make_fd (command)) { }
    ~opstream () { close(); }
  protected:
    FILE* fp;
    int make_fd (const std::string& command) { 
	// trace_macro ("! open output pipe: " << command);
    	fp = popen(command.c_str(),"w");
    	if (fp == 0) { throw "popen() failed"; }
	return fileno (fp);
    }
};
class ipstream : public fdistream {
  public:
    void open (const std::string& command) {
        setfd (make_fd (command));
    }
    void close () {
	if (fp) pclose(fp);
	fp = 0;
    }
    ipstream () : fdistream(0), fp(0) {}
    ipstream (const std::string& command)
      : fdistream (make_fd (command)) { }
    ~ipstream () { close(); }
  protected:
    FILE* fp;
    int make_fd (const std::string& command) { 
	// trace_macro ("! open input pipe: " << command);
    	fp = popen(command.c_str(),"r");
    	if (fp == 0) {
        	throw "popen() failed";
    	}
	return fileno (fp);
    }
};
}// namespace rheolef
#endif // _RHEO_PSTREAM_H
