/*- This file is part of the RKWard project (https://rkward.kde.org).
SPDX-FileCopyrightText: by Thomas Friedrichsmeier <thomas.friedrichsmeier@kdemail.net>
SPDX-FileContributor: The RKWard Team <rkward-devel@kde.org>
SPDX-License-Identifier: GPL-2.0-or-later
*/
include ("outliers_common.js");

function makeTestCall () {
	echo ('		t <- chisq.out.test (var, opposite = ' + getValue ("opposite") + ')\n');
	echo ('		results[i, ' + i18n ("X-squared") + '] <- t$statistic\n');
	echo ('		results[i, ' + i18n ("p-value") + '] <- t$p.value\n');
	echo ('		results[i, ' + i18n ("Alternative Hypothesis") + ']<- rk.describe.alternative (t)\n');
	echo ('		results[i, ' + i18n ("Variance") + '] <- var (var)\n');
}

function printout (is_preview) {
	if (!is_preview) {
		new Header (i18n ("Chi-squared test for outlier")).addFromUI ("opposite").print ();
	}
	echo ('rk.results (results)\n');
}
