# encoding: UTF-8

module Vines
  class Stream
    class Component
      class Ready < State
        def node(node)
          stanza = to_stanza(node)
          raise StreamErrors::UnsupportedStanzaType unless stanza
          to, from = stanza.validate_to, stanza.validate_from
          raise StreamErrors::ImproperAddressing unless to && from
          raise StreamErrors::InvalidFrom unless from.domain == stream.remote_domain
          stream.user = User.new(jid: from)
          if stanza.local? || stanza.to_pubsub_domain?
            stanza.process
          else
            stanza.route
          end
        end
      end
    end
  end
end
