---
layout: post
title: Polyglot 1.2.0
lang: fr
---
Une nouvelle version de Polyglot a été libéré! Essaie!

{% highlight yaml %}
gem install jekyll-polyglot
{% endhighlight %}

et la liste `jekyll-polyglot` parmi vos pierres précieuses figurant dans votre `_config.yml`

Elle consiste principalement bases pour se préparer à de nouvelles fonctionnalités et une meilleure gestion de contenu multilingue. Elle a une nouvelle fonctionnalité:

## {% raw %} {% I18n_Headers %} {% endraw %}

Mettez cette balise avec le [url de votre site](https://github.com/untra/polyglot/blob/site/_includes/head.html#L6) dans votre `head.html` comprend fichier pour obtenir le référencement maximum fourni par ayant un site Web multilingue. Il est le même que le code de liquide suivant:

{% highlight html %}{% raw %}
<meta http-equiv="Content-Language" content="{{site.active_lang}}">
<link rel="alternate"
      hreflang="{{site.default_lang}}"
      href="http://yoursite.com{{page.permalink}}" />
{% for lang in site.languages %}
{% if lang == site.default_lang %}
  {% continue %}
{% endif %}
<link rel="alternate"
    hreflang="{{lang}}"
    href="http://yoursite.com/{{lang}}{{page.permalink}}" />
{% endfor %}
{% endraw %}
{% endhighlight %}

Dans votre tête, mais plus rapide et plus propre! Pour plus d'informations, voir [la page SEO](/seo)
