Category: sss06
Date: Sep 10 2006
From: "Andrea Censi" <andrea.censi@dis.uniroma1.it>
Subject: A report about Oxford and the 2006 SLAM Summer School
Encoding: BlueCloth FlickrHTML
format: bluecloth>
inMenu: true

Let me quote the words of a renowned Oxford scholar:

> "Life is too important to be taken seriously."

If you do not wholeheartedly agree with this statement,
please stop reading this.

----------------------

I stayed three weeks in Oxford: one week for the SLAM school and,
before that, two weeks for an English course. You might ask: why?
A very good question indeed - "Why I am not on a sunny beach?" -
I kept asking myself as I walked down the misty alleys of the old town,
wearing a scarf on August, 16th, and realizing that - maybe - I would not
need the three pairs of shorts and the swimsuit I had brought.


Summary:

1. The Queen's English
2. The Harry Potter experience
3. Parsnip, Marmite and the tea conspiracy
4. The Summer School
5. Minor open issues in SLAM  

> Appendix: How to offend seven nationalities at once

`I`. The Queen's English
----------------------
 
It turns out that a course of English at an advanced level is mostly
about vocabulary and idioms: by the end of the first week I knew seven
different ways to address a "promiscuous" woman, and I can tell which ones
are applicable to American and which to British English. It remains to be
seen how this will benefit my academic writing.

It was a lot of fun to learn the differences (or, as the teacher put it,
"to purify my English after years of prolonged unhealthy exposure to American
media"), which are not only linguistic, but above all in attitude and
social norms.
For example, in the US the first question that people ask you is
"What do you do?" (meaning: "How much do you earn?"), while in England such
a question would be felt as unnecessary direct and impolite. 
As a rule,
it is compulsory to exchange comments about the weather, and there is a lot
of specialized vocabulary for this; the following table might prove handy
to understand your acquaintance:

- "It's a lovely day!" = "It doesn't rain"
- "It's a nice day!" = "It doesn't rain heavily"
- "What a wonderful day!"="This morning, at 10:13, I caught a glimpse of the sun"

(the correct answer to any of these is "isn't it?")

`II`. The Harry Potter experience
-------------------------

  flickr: http://www.flickr.com/photos/censi/232006603/

During my three-week stay I tried my best to immerse myself in the English
atmosphere.

I went to a place called Oxford Story [3], where we paid &pound;7 to go through a
painfully slow indoor ride, sat on a mobile school-desk in the dark for 25
minutes. It is the claustrophobic equivalent of the American Epcot center in
Disney World.

At Epcot, I learned that the final goal of all the scientific progress in the
last three millennia was to let Walt Disney broadcast Snow White using
Siemens equipment (Siemens sponsored the ride).
In Oxford, I learned that the glorious University is the repository of all
human knowledge, and that the English understatement is a legend. At the end of
the ride, I was amazed that in Italy I had managed to learn to read and write.

  flickr: http://www.flickr.com/photos/censi/232023681/

Still, one thing the ride did not explain is how the well-educated,
smart elite students of Oxford can possibly find rowing fun --
(probably it IS fun, compared to cricket).

  flickr: http://www.flickr.com/photos/censi/232529032/

I went to a candle-light baroque concert in the Exeter college chapel.
The ensemble was 75% Asian, all Oxford researchers, and we were given
a twenty minute speech about the effort they put in the historical
research of this obscure composer, that they had a microfilm of the original
manuscript delivered from a German library, that the viola would be played
in the original style, blah blah blah. Only in Oxford!

  flickr: http://www.flickr.com/photos/censi/232031895/

I read "The Hobbit" (Tolkien was a fellow of Exeter college) - I discovered
that the only two peoples in the known and invented universes to have
the concept of a "second breakfast" are Hobbits and Italians.


I watched a performance of MacBeth at an open-air theatre.
I couldn't understand but one sentence, which is worth mentioning:
"Alcohol provokes the desire, but it takes away the performance"

Regarding alcohol, England is one of the places where you can't drink if you
are under 21 (in Italy, at 18 you have decided to quit).
Young people have their ID checked at the entrance of pubs and in liquor
stores: that's only a minor annoyance, as they just need to wait outside
the store for the first Spanish guy passing by that will buy the wine for them
(and be compensated with just the change - did you keep the penny, Felix?).

Anyway the guys at the door use the ID checking mostly as a form of flattery:
"You are 32? I thought you were 20!" is probably the best pick-up line that
the English can come up with.

The other characteristic thing is that in English pubs there is no table
service: you have to walk to the bar and ask by yourself. The first time can
be confusing: and you can spend quite some time waiting at the table whining
about the "poor service".

`III`. Parsnip, Marmite & the tea conspiracy 
---------------------------------------------

During the first week I was a guest of a lovely 79-year-old lady.
Working at the University, she made a point of speaking very posh English.
And she made a point of cooking traditional English food.
The typical English dish is some meat with two vegetables aside.
For the vegetables, pick any two in {parsnip, carrot, potato}.

Don't look in your dictionary for a translation of "parsnip" as probably
there isn't one. The lady would tell me that in the next-to-last century,
this famous professor spent years raising the finest crossbreed of Parsnip as
to finally obtain what is best described as a big white carrot
with no taste whatsoever [4].

Nevertheless, the many regional variants give spectacular variety to the
English cuisine: the two vegetables can be boiled, fried, baked, microwaved,
or roasted. There exist also exotic twists, in which the vegetables are put
on top of the meat, or underneath, or even inside.
In important occasions, the recipes stay the same but gain a French name.


   flickr: http://www.flickr.com/photos/censi/232526897/


I tried a thing called Marmite, which the teacher sold to me as "the British
answer to Nutella". It has the aspect and consistency of engine grease, and,
as far as I know, also the taste is similar (I've never tasted the grease,
but next time, presented with choice, I'd give it a go).

The austerity of English food can be explained by the pitiless weather; but
how can you explain Marmite, if not with alimentary masochism?

But... there's one thing that is much better in England: tea. Wherever I tried
it (at the old lady's, at tearooms, at coffee breaks) it was sooo delicious.
In Italy we don't get the real thing. Why is that? Is this some sort of
conspiracy orchestrated by the Italian coffee producers? And is it the
tea cartello which does not allow good coffee to be imported in England?

`IV`. The Summer School
---------------------

If you go for a career in research, in general you don't get much money,
or fame, and you don't get to rescue the princess either.
The two benefits that you do get are: playing with very expensive toys
and the occasional trip in which you meet all sort of people.

And when you talk with them, it's sort of strange to realize that your
interlocutor is one of the 5 people - worldwide - that actually care about your
research theme, and yet the things you have in common end there, as he has
different culture, race, religion, and while you two happen to agree that Lie
brackets are an indispensable tool to characterize the propagation of errors
on the Euclidean group, you have very different answers to the important
questions about life, the universe and everything. (In these cases I have
anecdotal proof that it is much better to stick to research talk, and to
avoid at all costs the kind of jokes that you can find in the Appendix).

Instead, at this particular school, I would say that the European character was
clearly perceived, and I enjoyed it -- but whether England is in Europe is a
delicate matter.


Here are some impressions of the people.

 * Juan Domingo Tardos (aka Mingo) is the funniest of the bunch, the man you
   want to go partying with.
   
   He taught us two deep truths about SLAM and life:
   1. The size of your banana matters.
   2. Never under-estimate the size of your lemons.
   
   I thought: wow, I want to write a paper with "banana" in the title - finally
   some inspiration from the school! I already had big projects for Fig. 1,2
   and a full-page Fig. 3, but after a little googling I found:
   "Functional Programming with Bananas, Lenses, Envelopes and Barbed Wire"[5]
   "Dealing with large bananas" [6].
   I gave up: I cannot beat this last one. And the existence of [6] proves
   once again that SLAM is a solved problem.

 * Paul Newman, the organizer, told us, more than once, that the future of SLAM
   is in long term operation if we want the systems to be reliable.
   (Personally, I disagree: I think that it is possible to build anything at
   the desired level of reliability, given reasonable funding, time, and
   an appropriate number of German engineers)

 * One of the lessons learned in the school is that almost everything has
   already been done by someone else.
   More specifically, most of the things have already been done by
   Durrant-Whyte some twenty years ago, when men were men, CS was electrical
   engineering, master students knew calculus, and Kalman filters ran
   free in the wild lands of Australia.

 * Frank Dellaert is a jolly chap as well, and he does interesting things with
   graphs. As he introduced three different formalisms in the first
   three slides, I regretted not to have put more CS in my curriculum, then
   shut my eyes. Interestingly, at summer schools and conferences, if you close
   your eyes people assume that you are very smart and that you are thinking
   about some new impressive algorithm -- I was just dreaming of a sunny beach.

 * Henrik Christensen has implemented SLAM on the cleaning robot for $45
   in sensors and electronics. It puts things in perspective, especially
   if you consider that I paid  &pound;16 for a one-hour coach trip from Heathrow
   to Oxford.

 * Andy Davison is a wonderful person, he tutored the practicals with
   infinite patience. Never did I meet such a knowledgeable, affable,
   and humble person. (Probably he is the kind of person that some day will
   show up at work with automatic guns)

 * Wolfram Burgard - he wins my "best robot" award for the photo of our
   beloved Albert [7].

 * Dieter Fox wins "most nostalgic slide from the 90s": and every time we feel
   the same emotion as the first time.

 * Kurt Konolige reminded me why I bought a Mac.

 * Simon Lacroix - Once we sat at the same table during lunch. While he
   talked with Dellaert, he would send me alarmed glances, the kind of glances
   that you would reserve to a relative returning from death. I wanted
   to ask him why, but then I decided I'd better not to (was I so wasted
   from the night before?).

 * Simon Julier -- he seems very smart, but he lost me between slide #3 and #4.
   I started to be seasick from all those covariance matrices -
   so I muttered to my neighbours: "I wonder whether it still holds in
   higher-dimensional spaces...", then I closed my eyes and was back again on
   the sunny beach.

 * But all in all, the most interesting presentation was the magical show
   that Davide Scaramuzza (who at daytime pretends to work at ETHZ) gave to a
   selected audience after the banquet ([8]).
   It was another confirmation that all the time spent in front of a monitor is,
   in fact, wasted, and all of us should have studied card tricks instead:
   you have NO IDEA of how a girl's face brightens up and her eyes expand when
   she watches a magician.

`V`. Other minor issues in SLAM 
--------------------------------

We all know that the most important open problem in SLAM is that there are
not enough women doing research in the area and coming at summer schools.
As for the other minor issues, this is the result of asking
"What is the future of SLAM?" to a random sampling of the participants.
(the list does not include answers given after 10:00 PM)

 - For 30% of the respondents, SLAM is a solved problem, and we just need some
   German engineers to work out the details of the implementations.
 - Long term operation: make filters that reconsider their decisions at a
   a later time (so not delaying decisions, but explicitly reconsider).
 - Make it robust for real applications: or, your method should work in more
   than one experiment and possibly also outside of your lab.
 - Put more knowledge in SLAM about the environment. Teach your
   filter what is a tree, a road, a mirror so that it can make smarter
   decisions.
 - Active SLAM and SLAM-guided exploration (once we figure out good acronyms).
 - Some boring work is to be done for taking into account linearization errors
   in the already existing results about consistency, sparsity, etc.
 - "Where can I get some real coffee?" (2 people)
 - Methods and representations for real sensor fusion (laser, camera, etc).
 - Do robust stuff with a single camera. Omnidirectional cameras are cool.
   Mix different techniques at different time-scales: visual odometry between
   frames, then stable features, then databases of places to close the loop
   (or don't close the loop at all).

Appendix. How to offend seven nationalities at once
--------------------------------------------------

In Oxford I learned the ultimate rude stereotypical joke -- I think it's
worth sharing.

> **Heaven & Hell**
>
> *In Heaven*: the policemen are British, mechanics are German, chefs are French,
> wives are Japanese, neighbours are Dutch, lovers are Italian,
> and the Swiss organize it all.
>
> *In Hell*: the policemen are German, mechanics are French, chefs are British,
> neighbours are Japanese, wives are Dutch, lovers are Swiss,
> and the Italians organize it all.

For related work, see for example [9], [10].


And here's the research version:

> **The BEST international research project**
> 
> - The French do the overall math analysis,
> - a Chinese refines a ten-line proof of the main Theorem,
> - the Germans design the implementation,
> - Japanese undergrads do the actual work,
> - the British write the paper,
> - an American gives the presentation,
> - the Spanish organize the social events,
> - and the Italians organize the banquet.
> 
> **The WORST international research project**
> 
> - The Germans do the overall math analysis,
> - an American PhD student spends 10 CPU year on his department's 48-node
> cluster and proves with a Monte Carlo simulation in Matlab that
> Theorem 1 indeed holds for some values of the parameters,
> - the French design the implementation,
> - one Spanish undergrad does the actual work,
> - the Italians write the papers,
> - a Chinese gives the presentation,
> - the Japanese organize the social events,
> - and the British organize the banquet.

`:-)`

  Flickr: <http://www.flickr.com/photos/censi/232003838>

References
----------

\[1\]   [http://www.spellingsociety.org/news/media/poems.php](http://www.spellingsociety.org/news/media/poems.php)  
\[2\] dde [http://www.flickr.com/photos/censi/236722418/](http://www.flickr.com/photos/censi/236722418/)  
\[3\]  [http://www.oxfordstory.co.uk](http://www.oxfordstory.co.uk)  
\[4\]   [http://www.botanical.com/botanical/mgmh/p/parsni12.html](http://www.botanical.com/botanical/mgmh/p/parsni12.html  )  
\[5\]  E. Meijer, M. Fokkinga, R. Paterson. "Functional Programming with Bananas, Lenses, Envelopes and Barbed Wire" (1991)  
 [http://citeseer.ist.psu.edu/meijer91functional.html](http://citeseer.ist.psu.edu/meijer91functional.html)  
\[6\]  R. Lammel, J. Visser, J. Kort. "Dealing with large bananas" (2000) <http://citeseer.ist.psu.edu/lammel00dealing.html>  
\[7\]  [http://www.informatik.uni-freiburg.de/~burgard/](http://citeseer.ist.psu.edu/lammel00dealing.html)  
\[8\]  [http://asl.epfl.ch/~scaramuz/cabaret/cabaret.wmv](http://asl.epfl.ch/~scaramuz/cabaret/cabaret.wmv)  
\[9\]  [http://www.anth.uconn.edu/faculty/boster/cultvar/euweb/](http://www.anth.uconn.edu/faculty/boster/cultvar/euweb/)  
\[10\]  [http://www.infonegocio.com/xeron/bruno/italy.html](http://www.infonegocio.com/xeron/bruno/italy.html)  
