# Welcome to Sidekiq 4.0!

Sidekiq 4.0 contains a redesigned, more efficient core with less overhead per job.
See my blog for [an overview of Sidekiq 4's higher performance](http://www.mikeperham.com/2015/10/14/optimizing-sidekiq/).

## What's New

* Sidekiq no longer uses Celluloid.  If your application code uses Celluloid,
  you will need to pull it in yourself.

* `redis-namespace` has been removed from Sidekiq's gem dependencies. If
  you want to use namespacing ([and I strongly urge you not to](http://www.mikeperham.com/2015/09/24/storing-data-with-redis/)), you'll need to add the gem to your Gemfile:
```ruby
gem 'redis-namespace'
```

* **Redis 2.8.0 or greater is required.**  Redis 2.8 was released two years
  ago and contains **many** useful features which Sidekiq couldn't
  leverage until now.  **Redis 3.0.3 or greater is recommended** for large
  scale use [#2431](https://github.com/mperham/sidekiq/issues/2431).

* Jobs are now fetched from Redis in parallel, making Sidekiq more
  resilient to high network latency.  This means that Sidekiq requires
  more Redis connections per process.  You must have a minimum of
  `concurrency + 2` connections in your pool or Sidekiq will exit.
  When in doubt, let Sidekiq size the connection pool for you.

* Worker data is no longer updated in real-time but rather upon every
  heartbeat.  Don't expect the `Sidekiq::Workers` API to be millisecond-precise.

* There's a new testing API based off the `Sidekiq::Queues` namespace. All
  assertions made against the Worker class still work as expected.
```ruby
assert_equal 0, Sidekiq::Queues["default"].size
HardWorker.perform_async("log")
assert_equal 1, Sidekiq::Queues["default"].size
assert_equal "log", Sidekiq::Queues["default"].first['args'][0]
Sidekiq::Queues.clear_all
```

## Upgrade

First, make sure you are using Redis 2.8 or greater. Next:

* Upgrade to the latest Sidekiq 3.x.
```ruby
gem 'sidekiq', '< 4'
```
* Fix any deprecation warnings you see.
* Upgrade to 4.x.
```ruby
gem 'sidekiq', '< 5'
```
