use std::{error::Error, io, process};

fn example() -> Result<(), Box<dyn Error>> {
    let mut rdr =
        csv::ReaderBuilder::new().delimiter(b':').from_reader(io::stdin());
    for result in rdr.records() {
        let record = result?;
        println!("{:?}", record);
    }
    Ok(())
}

fn main() {
    if let Err(err) = example() {
        println!("error running example: {}", err);
        process::exit(1);
    }
}
